/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.handles;

import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.SeekableByteChannel;
import java.util.Objects;

public class ArrayByteChannel
implements SeekableByteChannel {
    private boolean closed = false;
    private int position = 0;
    private final byte[] backing;

    public ArrayByteChannel(byte[] backing) {
        this.backing = backing;
    }

    @Override
    public int read(ByteBuffer destination) throws ClosedChannelException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        Objects.requireNonNull(destination, "destination");
        if (this.position >= this.backing.length) {
            return -1;
        }
        int remaining = Math.min(this.backing.length - this.position, destination.remaining());
        destination.put(this.backing, this.position, remaining);
        this.position += remaining;
        return remaining;
    }

    @Override
    public int write(ByteBuffer src) throws ClosedChannelException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        throw new NonWritableChannelException();
    }

    @Override
    public long position() throws ClosedChannelException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        return this.position;
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws ClosedChannelException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        if (newPosition < 0L || newPosition > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Position out of bounds");
        }
        this.position = (int)newPosition;
        return this;
    }

    @Override
    public long size() throws ClosedChannelException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        return this.backing.length;
    }

    @Override
    public SeekableByteChannel truncate(long size) throws ClosedChannelException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        throw new NonWritableChannelException();
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() {
        this.closed = true;
    }
}

