/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render.vbo;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import dan200.computercraft.client.render.vbo.DirectBuffers;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.ShaderInstance;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.opengl.GL45C;

public class DirectVertexBuffer
extends VertexBuffer {
    private int actualIndexCount;

    public DirectVertexBuffer() {
        super(VertexBuffer.Usage.STATIC);
        if (DirectBuffers.HAS_DSA) {
            RenderSystem.glDeleteBuffers((int)this.vertexBufferId);
            if (DirectBuffers.ON_LINUX) {
                BufferUploader.reset();
            }
            this.vertexBufferId = GL45C.glCreateBuffers();
        }
    }

    public void upload(int vertexCount, VertexFormat.Mode mode, VertexFormat format, ByteBuffer buffer) {
        RenderSystem.AutoStorageIndexBuffer indexBuffer;
        this.bind();
        this.mode = mode;
        this.actualIndexCount = this.indexCount = mode.indexCount(vertexCount);
        this.indexType = VertexFormat.IndexType.SHORT;
        RenderSystem.assertOnRenderThread();
        DirectBuffers.setBufferData(34962, this.vertexBufferId, buffer, 35044);
        if (format != this.format) {
            if (this.format != null) {
                this.format.clearBufferState();
            }
            this.format = format;
            GL15C.glBindBuffer((int)34962, (int)this.vertexBufferId);
            format.setupBufferState();
            GL15C.glBindBuffer((int)34962, (int)0);
        }
        if ((indexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.Mode)mode)) != this.sequentialIndices || !indexBuffer.hasStorage(this.indexCount)) {
            indexBuffer.bind(this.indexCount);
            this.sequentialIndices = indexBuffer;
        }
    }

    public void drawWithShader(Matrix4f modelView, Matrix4f projection, ShaderInstance shader, int indexCount) {
        this.indexCount = indexCount;
        this.drawWithShader(modelView, projection, shader);
        this.indexCount = this.actualIndexCount;
    }

    public int getIndexCount() {
        return this.actualIndexCount;
    }

    public void close() {
        super.close();
        if (DirectBuffers.ON_LINUX) {
            BufferUploader.reset();
        }
    }
}

