/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.turtle;

import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleToolDurability;
import dan200.computercraft.api.upgrades.UpgradeBase;
import dan200.computercraft.impl.ComputerCraftAPIService;
import dan200.computercraft.impl.upgrades.TurtleToolSpec;
import java.util.Optional;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jspecify.annotations.Nullable;

public final class TurtleToolBuilder {
    private final ResourceKey<ITurtleUpgrade> id;
    private final Item item;
    private Component adjective;
    private float damageMultiplier = 3.0f;
    private @Nullable TagKey<Block> breakable;
    private boolean allowEnchantments = false;
    private TurtleToolDurability consumeDurability = TurtleToolDurability.NEVER;

    private TurtleToolBuilder(ResourceKey<ITurtleUpgrade> id, Item item) {
        this.id = id;
        this.adjective = Component.translatable((String)UpgradeBase.getDefaultAdjective(id.location()));
        this.item = item;
    }

    public static TurtleToolBuilder tool(ResourceLocation id, Item item) {
        return new TurtleToolBuilder(ITurtleUpgrade.createKey(id), item);
    }

    public static TurtleToolBuilder tool(ResourceKey<ITurtleUpgrade> id, Item item) {
        return new TurtleToolBuilder(id, item);
    }

    public ResourceKey<ITurtleUpgrade> id() {
        return this.id;
    }

    public TurtleToolBuilder adjective(Component adjective) {
        this.adjective = adjective;
        return this;
    }

    public TurtleToolBuilder damageMultiplier(float damageMultiplier) {
        this.damageMultiplier = damageMultiplier;
        return this;
    }

    public TurtleToolBuilder allowEnchantments() {
        this.allowEnchantments = true;
        return this;
    }

    public TurtleToolBuilder consumeDurability(TurtleToolDurability durability) {
        this.consumeDurability = durability;
        return this;
    }

    public TurtleToolBuilder breakable(TagKey<Block> breakable) {
        this.breakable = breakable;
        return this;
    }

    public ITurtleUpgrade build() {
        return ComputerCraftAPIService.get().createTurtleTool(new TurtleToolSpec(this.adjective, this.item, this.damageMultiplier, this.allowEnchantments, this.consumeDurability, Optional.ofNullable(this.breakable)));
    }

    public void register(BootstrapContext<ITurtleUpgrade> upgrades) {
        upgrades.register(this.id(), (Object)this.build());
    }
}

