/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.client;

import dan200.computercraft.impl.client.ClientPlatformHelper;
import java.util.stream.Stream;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import org.jspecify.annotations.Nullable;

public final class ModelLocation {
    private final ModelResourceLocation modelLocation;
    private final @Nullable ResourceLocation resourceLocation;

    private ModelLocation(ModelResourceLocation modelLocation, @Nullable ResourceLocation resourceLocation) {
        this.modelLocation = modelLocation;
        this.resourceLocation = resourceLocation;
    }

    public static ModelLocation ofModel(ModelResourceLocation location) {
        return new ModelLocation(location, null);
    }

    public static ModelLocation ofResource(ResourceLocation location) {
        return new ModelLocation(new ModelResourceLocation(location, "standalone"), location);
    }

    public BakedModel getModel(ModelManager manager) {
        return ClientPlatformHelper.get().getModel(manager, this.modelLocation, this.resourceLocation);
    }

    public Stream<ResourceLocation> getDependencies() {
        return this.resourceLocation == null ? Stream.empty() : Stream.of(this.resourceLocation);
    }
}

