/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.vapourware.shared.utils;

import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;

public class WeightedRandom<T> {
    private final NavigableMap<Double, T> weightMap = new TreeMap<Double, T>();
    private final Random random = new Random();
    private double totalWeight = 0.0;

    public WeightedRandom(Map<T, Double> weights) {
        for (Map.Entry<T, Double> entry : weights.entrySet()) {
            if (entry.getValue() < 0.0) {
                throw new IllegalArgumentException("Weights cannot be negative");
            }
            this.totalWeight += entry.getValue().doubleValue();
            this.weightMap.put(this.totalWeight, entry.getKey());
        }
    }

    public T nextRandomItem() {
        double value = this.random.nextDouble() * this.totalWeight;
        return this.weightMap.higherEntry(value).getValue();
    }
}

