/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.vapourware.shared.utils;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class RegistryUtils {
    public static boolean modItemExists(String namespace, String tail) {
        return BuiltInRegistries.ITEM.containsKey(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)tail));
    }

    public static Item getModItem(String namespace, String tail) {
        return (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)tail));
    }

    public static boolean itemTagIsNotEmpty(String namespace, String tail) {
        TagKey<Item> tag = RegistryUtils.getItemTag(namespace, tail);
        for (Item item : BuiltInRegistries.ITEM) {
            ItemStack stack = new ItemStack((ItemLike)item);
            if (!stack.is(tag)) continue;
            return true;
        }
        return false;
    }

    public static Ingredient getIngredientFromTag(String namespace, String tail) {
        return Ingredient.of(RegistryUtils.getItemTag(namespace, tail));
    }

    public static TagKey<Item> getItemTag(String namespace, String tail) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)tail));
    }

    public static TagKey<Block> getBlockTag(String namespace, String tail) {
        return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)tail));
    }
}

