/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.vapourware.shared.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import vapourdrive.vapourware.VapourWare;
import vapourdrive.vapourware.shared.base.IFuelUser;
import vapourdrive.vapourware.shared.base.ITickingContainer;

public class MachineUtils {
    public static int getBurnDuration(ItemStack stack, IFuelUser machine) {
        if (stack.isEmpty()) {
            return 0;
        }
        return (int)((double)(stack.getBurnTime(RecipeType.SMELTING) * 100) * machine.getEfficiencyMultiplier());
    }

    public static List<ItemStack> cleanItemStacks(Iterable<? extends ItemStack> stacks) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (ItemStack itemStack : stacks) {
            if (ret.isEmpty()) {
                ret.add(itemStack);
                continue;
            }
            for (ItemStack retStack : ret) {
                if (ItemStack.isSameItemSameComponents((ItemStack)retStack, (ItemStack)itemStack) && retStack.getCount() < retStack.getMaxStackSize()) {
                    int change = Math.min(itemStack.getCount(), retStack.getMaxStackSize() - retStack.getCount());
                    retStack.grow(change);
                    itemStack.shrink(change);
                }
                if (!itemStack.isEmpty()) continue;
                break;
            }
            if (itemStack.isEmpty()) continue;
            ret.add(itemStack);
        }
        return ret;
    }

    public static int getTotalCount(Iterable<? extends ItemStack> stacks) {
        int count = 0;
        for (ItemStack itemStack : stacks) {
            count += itemStack.getCount();
        }
        return count;
    }

    public static void playSound(Level world, BlockPos pos, RandomSource rand, SoundEvent sound, float pitch) {
        MachineUtils.playSound(world, pos, rand, sound, pitch, 1.0f);
    }

    public static void playSound(Level world, BlockPos pos, RandomSource rand, SoundEvent sound, float pitch, float volume) {
        if (pitch == 0.0f) {
            pitch = 1.0f + (rand.nextFloat() - 0.5f) / 2.0f;
        }
        world.playSound(null, pos, sound, SoundSource.BLOCKS, volume *= 1.0f + (rand.nextFloat() - 0.5f) / 2.0f, pitch);
    }

    public static void doFuelProcess(ItemStack fuel, IFuelUser user) {
        if (user.getFuelToAdd() == 0) {
            user.setFuelToAdd(MachineUtils.tryConsumeFuelStack(fuel, user));
            if (!user.addFuel(user.getFuelToAdd(), true)) {
                user.setFuelToAdd(user.getMaxFuel() - user.getCurrentFuel());
            }
            user.setIncrementalFuelToAdd(user.getFuelToAdd() / 10);
        }
        if (user.getFuelToAdd() > 0) {
            user.addFuel(user.getIncrementalFuelToAdd(), false);
            user.setFuelToAdd(user.getFuelToAdd() - user.getIncrementalFuelToAdd());
            if (user.getFuelToAdd() < user.getIncrementalFuelToAdd()) {
                user.addFuel(user.getFuelToAdd(), false);
                user.setFuelToAdd(0);
            }
        }
    }

    public static int tryConsumeFuelStack(ItemStack fuel, IFuelUser user) {
        if (!fuel.isEmpty()) {
            if (user.getCurrentFuelStack().isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)user.getCurrentFuelStack(), (ItemStack)fuel)) {
                user.setCurrentFuelStack(fuel.copy());
                user.setCurrentBurn(MachineUtils.getBurnDuration(fuel, user));
            }
            if (user.getCurrentFuel() + user.getCurrentBurn() <= user.getMaxFuel() || user.getCurrentFuel() < user.getMinFuelToWork()) {
                VapourWare.debugLog("Fuel: " + user.getCurrentFuel() + " current burn: " + user.getCurrentBurn());
                if (user.getCurrentFuelStack().hasCraftingRemainingItem()) {
                    ItemStack fuelRemainder = user.getCurrentFuelStack().getCraftingRemainingItem();
                    if (MachineUtils.canPushAllOutputs(Collections.singletonList(fuelRemainder), user)) {
                        MachineUtils.pushOutput(fuelRemainder, false, user);
                    } else {
                        return 0;
                    }
                }
                user.removeFromSlot(Area.FUEL, 0, 1, false);
                if (!ItemStack.isSameItemSameComponents((ItemStack)user.getCurrentFuelStack(), (ItemStack)fuel)) {
                    user.setCurrentFuelStack(ItemStack.EMPTY);
                    user.setCurrentBurn(MachineUtils.getBurnDuration(fuel, user));
                }
                VapourWare.debugLog("CurrentBurn: " + user.getCurrentBurn());
                return user.getCurrentBurn();
            }
        }
        return 0;
    }

    public static boolean canPushAllOutputs(List<ItemStack> stacks, ITickingContainer user) {
        int empties = MachineUtils.getEmptyOutputSlotCount(user);
        if (empties >= stacks.size()) {
            return true;
        }
        if (empties == 0) {
            for (ItemStack stack : stacks) {
                if (MachineUtils.pushOutput(stack, true, user) >= 1) continue;
                return false;
            }
        } else {
            int eligible = 0;
            for (ItemStack stack : stacks) {
                for (int i : user.getOutputSlots()) {
                    if (user.getStackInSlot(Area.OUTPUT, i).isEmpty() || user.insertToSlot(Area.OUTPUT, i, stack, true) != ItemStack.EMPTY) continue;
                    ++eligible;
                }
            }
            return empties + eligible >= stacks.size();
        }
        return true;
    }

    public static int pushOutput(ItemStack stack, boolean simulate, ITickingContainer user) {
        int available = 0;
        int empty = 0;
        ItemStack result = stack.copy();
        for (int i : user.getOutputSlots()) {
            if (user.getStackInSlot(Area.OUTPUT, i).isEmpty() || user.insertToSlot(Area.OUTPUT, i, result, simulate) != ItemStack.EMPTY) continue;
            if (!simulate) {
                return -1;
            }
            ++available;
        }
        for (int i : user.getOutputSlots()) {
            if (!user.getStackInSlot(Area.OUTPUT, i).isEmpty() || user.insertToSlot(Area.OUTPUT, i, result, simulate) != ItemStack.EMPTY) continue;
            if (!simulate) {
                return -1;
            }
            ++empty;
        }
        if (empty == 0) {
            return Math.min(available, 1);
        }
        return available + empty;
    }

    public static int getEmptyOutputSlotCount(ITickingContainer user) {
        int empty = 0;
        for (int i : user.getOutputSlots()) {
            if (!user.getStackInSlot(Area.OUTPUT, i).isEmpty()) continue;
            ++empty;
        }
        return empty;
    }

    public static enum Area {
        FUEL,
        OUTPUT,
        AUX_1,
        AUX_2,
        INGREDIENT_1,
        INGREDIENT_2,
        INGREDIENT_3,
        AUGMENT,
        TOOL,
        STORAGE;

    }
}

