/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.vapourware.shared.utils;

import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class InvUtils {
    public static NonNullList<ItemStack> getIngredientsFromInvHandler(IItemHandler handler) {
        NonNullList stacks = NonNullList.withSize((int)handler.getSlots(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < stacks.size(); ++i) {
            stacks.set(i, (Object)handler.getStackInSlot(i));
        }
        return stacks;
    }

    public static int getEmptyOutputSlotCount(IItemHandler inv) {
        int empty = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (!inv.getStackInSlot(i).isEmpty()) continue;
            ++empty;
        }
        return empty;
    }

    public static boolean pushStack(ItemStack stack, boolean simulate, IItemHandler inv) {
        int i;
        ItemStack procStack = stack.copy();
        for (i = 0; i < inv.getSlots(); ++i) {
            if (inv.getStackInSlot(i).isEmpty()) continue;
            ItemStack changedStack = inv.insertItem(i, procStack, simulate);
            if (changedStack == ItemStack.EMPTY) {
                return true;
            }
            if (changedStack.getCount() == procStack.getCount()) continue;
            procStack = changedStack.copy();
        }
        for (i = 0; i < inv.getSlots(); ++i) {
            if (!inv.getStackInSlot(i).isEmpty() || inv.insertItem(i, procStack, simulate) != ItemStack.EMPTY) continue;
            return true;
        }
        return false;
    }
}

