/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.vapourware.shared.utils;

import net.minecraft.network.chat.MutableComponent;
import net.neoforged.neoforge.common.ModConfigSpec;
import vapourdrive.vapourware.shared.utils.CompUtils;

public class DeferredComponent {
    private final String modID;
    private final String tail;
    private final ModConfigSpec.ConfigValue<?> configValue;
    private final Object arg;

    public DeferredComponent(String modIDIn, String tailIn, ModConfigSpec.ConfigValue<?> configValueIn) {
        this.modID = modIDIn;
        this.tail = tailIn;
        this.configValue = configValueIn;
        this.arg = null;
    }

    public DeferredComponent(String modIDIn, String tailIn, Object argIn) {
        this.modID = modIDIn;
        this.tail = tailIn;
        this.configValue = null;
        this.arg = argIn;
    }

    public DeferredComponent(String tailIn, ModConfigSpec.ConfigValue<?> configValueIn) {
        this.modID = "vapourware";
        this.tail = tailIn;
        this.configValue = configValueIn;
        this.arg = null;
    }

    public DeferredComponent(String modIDIn, String tailIn) {
        this.modID = modIDIn;
        this.tail = tailIn;
        this.configValue = null;
        this.arg = null;
    }

    public DeferredComponent(String tailIn) {
        this.modID = "vapourware";
        this.tail = tailIn;
        this.configValue = null;
        this.arg = null;
    }

    public MutableComponent get() {
        if (this.configValue != null) {
            return CompUtils.getArgComp(this.modID, this.tail, this.configValue.get());
        }
        if (this.arg != null) {
            return CompUtils.getArgComp(this.modID, this.tail, this.arg);
        }
        return CompUtils.getComp(this.modID, this.tail);
    }

    public String getMod() {
        return this.modID;
    }

    public String getTail() {
        return this.tail;
    }
}

