/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.vapourware.shared.integrations.jade;

import java.text.DecimalFormat;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import vapourdrive.vapourware.shared.base.IFuelUser;
import vapourdrive.vapourware.shared.integrations.jade.JadePlugin;
import vapourdrive.vapourware.shared.utils.CompUtils;

public enum IFuelUserContentProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;

    private final DecimalFormat df = new DecimalFormat("#,###");

    public void appendTooltip(ITooltip tooltip, BlockAccessor blockAccessor, IPluginConfig pluginConfig) {
        if (blockAccessor.getServerData().contains("Fuel")) {
            int i = blockAccessor.getServerData().getInt("Fuel");
            tooltip.add((Component)CompUtils.getArgComp("fuel", this.df.format(i)).withStyle(ChatFormatting.GOLD));
        }
    }

    public ResourceLocation getUid() {
        return JadePlugin.FUEL;
    }

    public void appendServerData(CompoundTag tag, BlockAccessor blockAccessor) {
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof IFuelUser) {
            IFuelUser user = (IFuelUser)blockEntity;
            tag.putInt("Fuel", user.getCurrentFuel() / 100);
        }
    }
}

