/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.vapourware.shared.base;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vapourdrive.vapourware.shared.base.AbstractBaseContainerMenu;
import vapourdrive.vapourware.shared.base.AbstractBaseFuelUserTile;

public abstract class AbstractBaseMachineMenu
extends AbstractBaseContainerMenu {
    protected final AbstractBaseFuelUserTile baseFuelUserTile;
    protected final ContainerData machineData;

    public AbstractBaseMachineMenu(int windowId, Level world, BlockPos pos, Inventory inv, Player player, @Nullable MenuType<?> menu, ContainerData machineData) {
        super(windowId, world, pos, inv, player, menu);
        this.baseFuelUserTile = (AbstractBaseFuelUserTile)world.getBlockEntity(pos);
        this.machineData = machineData;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getFuelPercentage() {
        int i = this.machineData.get(0);
        if (i == 0) {
            return 0.0f;
        }
        return (float)i / (float)this.baseFuelUserTile.getMaxFuel();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getMaxFuel() {
        return this.baseFuelUserTile.getMaxFuel();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getFuelStored() {
        return this.machineData.get(0);
    }
}

