/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.vapourware.shared.base;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBaseContainerMenu
extends AbstractContainerMenu {
    public static final int PLAYER_INVENTORY_XPOS = 8;
    public static final int PLAYER_INVENTORY_YPOS = 84;
    protected final Player playerEntity;
    protected final IItemHandler playerInventory;
    protected final Inventory playerInv;
    protected final Level world;
    protected final BlockEntity tileEntity;

    public AbstractBaseContainerMenu(int windowId, Level world, BlockPos pos, Inventory inv, Player player, @Nullable MenuType<?> menu) {
        super(menu, windowId);
        this.playerEntity = player;
        this.playerInventory = new InvWrapper((Container)inv);
        this.playerInv = inv;
        this.world = world;
        this.tileEntity = world.getBlockEntity(pos);
    }

    protected void addSplitDataSlots(final ContainerData data) {
        int i = 0;
        while (i < data.getCount()) {
            final int index = i++;
            this.addDataSlot(new DataSlot(this){

                public int get() {
                    return data.get(index) & 0xFFFF;
                }

                public void set(int value) {
                    int stored = data.get(index) & 0xFFFF0000;
                    data.set(index, stored + (value & 0xFFFF));
                }
            });
            this.addDataSlot(new DataSlot(this){

                public int get() {
                    return data.get(index) >> 16 & 0xFFFF;
                }

                public void set(int value) {
                    int stored = data.get(index) & 0xFFFF;
                    data.set(index, stored | value << 16);
                }
            });
        }
    }

    public boolean stillValid(@NotNull Player playerIn) {
        return true;
    }

    private int addPlayerInvRow(IItemHandler handler, int index, int x, int y) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot((Slot)new SlotItemHandler(handler, index, x, y));
            x += 18;
            ++index;
        }
        return index;
    }

    private void addPlayerInv(IItemHandler handler, int index, int x, int y) {
        for (int j = 0; j < 3; ++j) {
            index = this.addPlayerInvRow(handler, index, x, y);
            y += 18;
        }
    }

    protected void layoutPlayerInventorySlots(int leftCol, int topRow) {
        int k;
        for (k = 0; k < 3; ++k) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)this.playerInv, j + k * 9 + 9, leftCol + j * 18, topRow + k * 18));
            }
        }
        for (k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)this.playerInv, k, leftCol + k * 18, topRow + 58));
        }
    }
}

