/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.vapourware.content;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import vapourdrive.vapourware.shared.base.AbstractBaseContainerBlock;
import vapourdrive.vapourware.shared.base.BaseInfoItem;
import vapourdrive.vapourware.shared.utils.DeferredComponent;

public class HandymanWrench
extends BaseInfoItem {
    public static final TagKey<Item> wrench = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"tools/wrench"));

    public HandymanWrench(Item.Properties pProperties) {
        super(pProperties.stacksTo(1), new DeferredComponent("wrench.info"));
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext ctx) {
        AbstractBaseContainerBlock machine;
        Block block;
        BlockPos pos = ctx.getClickedPos();
        BlockState state = ctx.getLevel().getBlockState(pos);
        if (Objects.requireNonNull(ctx.getPlayer()).isCrouching() && (block = state.getBlock()) instanceof AbstractBaseContainerBlock && (machine = (AbstractBaseContainerBlock)block).sneakWrenchMachine(ctx.getPlayer(), ctx.getLevel(), pos)) {
            return InteractionResult.SUCCESS;
        }
        ctx.getLevel().setBlockAndUpdate(pos, state.rotate((LevelAccessor)ctx.getLevel(), pos, Rotation.CLOCKWISE_90));
        return InteractionResult.SUCCESS;
    }
}

