/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.furnacemk2.utils;

import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;

public class FurnaceUtils {
    public static boolean canSmelt(ItemStack stack, Level world) {
        return world.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(stack), world).isPresent();
    }

    public static float getExperience(Level world, ItemStack itemStack) {
        Optional<RecipeHolder<SmeltingRecipe>> matchingRecipe = FurnaceUtils.getMatchingRecipeForInput(world, itemStack);
        return matchingRecipe.map(holder -> Float.valueOf(((SmeltingRecipe)holder.value()).getExperience())).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public static int getCookTime(Level world, ItemStack itemStack) {
        Optional<RecipeHolder<SmeltingRecipe>> matchingRecipe = FurnaceUtils.getMatchingRecipeForInput(world, itemStack);
        return matchingRecipe.map(holder -> ((SmeltingRecipe)holder.value()).getCookingTime()).orElse(200) * 100;
    }

    public static ItemStack getSmeltingResultForItem(Level world, ItemStack itemStack) {
        Optional<RecipeHolder<SmeltingRecipe>> matchingRecipe = FurnaceUtils.getMatchingRecipeForInput(world, itemStack);
        return matchingRecipe.map(holder -> ((SmeltingRecipe)holder.value()).getResultItem((HolderLookup.Provider)world.registryAccess()).copy()).orElse(ItemStack.EMPTY);
    }

    public static Optional<RecipeHolder<SmeltingRecipe>> getMatchingRecipeForInput(Level world, ItemStack itemStack) {
        RecipeManager recipeManager = world.getRecipeManager();
        SingleRecipeInput singleItemInventory = new SingleRecipeInput(itemStack);
        return recipeManager.getRecipeFor(RecipeType.SMELTING, (RecipeInput)singleItemInventory, world);
    }
}

