/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.furnacemk2.utils;

import net.minecraft.world.entity.player.Player;

public class ExperienceUtils {
    public static int getPlayerXP(Player player) {
        return (int)((float)ExperienceUtils.getExperienceForLevel(player.experienceLevel) + player.experienceProgress * (float)player.getXpNeededForNextLevel());
    }

    public static void addPlayerXP(Player player, int amount) {
        int experience;
        player.totalExperience = experience = ExperienceUtils.getPlayerXP(player) + amount;
        player.experienceLevel = ExperienceUtils.getLevelForExperience(experience);
        int expForLevel = ExperienceUtils.getExperienceForLevel(player.experienceLevel);
        player.experienceProgress = (float)(experience - expForLevel) / (float)player.getXpNeededForNextLevel();
    }

    public static int xpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    private static int sum(int n, int a0, int d) {
        return n * (2 * a0 + (n - 1) * d) / 2;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level <= 15) {
            return ExperienceUtils.sum(level, 7, 2);
        }
        if (level <= 30) {
            return 315 + ExperienceUtils.sum(level - 15, 37, 5);
        }
        return 1395 + ExperienceUtils.sum(level - 30, 112, 9);
    }

    public static int getLevelForExperience(int targetXp) {
        int level = 0;
        int xpToNextLevel;
        while (targetXp >= (xpToNextLevel = ExperienceUtils.xpBarCap(level))) {
            ++level;
            targetXp -= xpToNextLevel;
        }
        return level;
    }
}

