/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.furnacemk2.items;

import java.text.DecimalFormat;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import vapourdrive.furnacemk2.config.ConfigSettings;

public class ItemFurnaceCore
extends Item {
    public String type;

    public ItemFurnaceCore(String type) {
        super(new Item.Properties().stacksTo(1));
        this.type = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)("message.furnace_core." + this.type + ".1")).withStyle(ChatFormatting.GREEN));
        tooltipComponents.add((Component)Component.translatable((String)("message.furnace_core." + this.type + ".2")).withStyle(ChatFormatting.BLUE));
        DecimalFormat df = new DecimalFormat("#,###");
        if (Objects.equals(this.type, "speed")) {
            tooltipComponents.add((Component)Component.literal((String)(df.format((Double)ConfigSettings.FURNACE_UPGRADED_SPEED.get() * 100.0) + "% speed")).withStyle(ChatFormatting.BLUE));
        } else if (Objects.equals(this.type, "experience")) {
            tooltipComponents.add((Component)Component.literal((String)(df.format((Double)ConfigSettings.FURNACE_UPGRADED_EXPERIENCE.get() * 100.0) + "% experience")).withStyle(ChatFormatting.BLUE));
        } else if (Objects.equals(this.type, "efficiency")) {
            tooltipComponents.add((Component)Component.literal((String)(df.format((Double)ConfigSettings.FURNACE_UPGRADED_EFFICIENCY.get() * 100.0) + "% fuel efficiency")).withStyle(ChatFormatting.BLUE));
        }
    }
}

