/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.furnacemk2.items;

import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import vapourdrive.furnacemk2.config.ConfigSettings;
import vapourdrive.furnacemk2.items.IExperienceStorage;
import vapourdrive.furnacemk2.setup.Registration;
import vapourdrive.furnacemk2.utils.ExperienceUtils;
import vapourdrive.vapourware.shared.utils.CompUtils;

public class ItemCrystal
extends Item
implements IExperienceStorage {
    public static final String TAG_EXPERIENCE = "FurnaceMK2.Crystal.Experience";

    public ItemCrystal() {
        super(new Item.Properties().stacksTo(1));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        int storedXP = this.getCurrentExperienceStored(stack);
        if (player.isShiftKeyDown() && storedXP < this.getMaxExperienceStored(stack)) {
            int xpForCurrentLevel = ExperienceUtils.getExperienceForLevel(player.experienceLevel);
            int xpToStore = ExperienceUtils.getPlayerXP(player) - xpForCurrentLevel;
            if (xpToStore == 0 && player.experienceLevel > 0) {
                xpToStore = xpForCurrentLevel - ExperienceUtils.getExperienceForLevel(player.experienceLevel - 1);
            }
            if (xpToStore == 0) {
                return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
            }
            int actuallyStored = this.receiveExperience(stack, xpToStore, false);
            if (actuallyStored > 0) {
                ExperienceUtils.addPlayerXP(player, -actuallyStored);
            }
            if (world.isClientSide()) {
                world.playSound(player, player.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.05f, this.getPitch(world.getRandom(), stack));
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (!player.isShiftKeyDown() && storedXP > 0) {
            int xpForPlayer = ExperienceUtils.getExperienceForLevel(player.experienceLevel + 1) - ExperienceUtils.getPlayerXP(player);
            int xpToRetrieve = (int)((double)xpForPlayer);
            int actuallyRemoved = this.extractExperience(stack, xpToRetrieve, false);
            if (actuallyRemoved < xpForPlayer) {
                xpForPlayer = (int)((double)actuallyRemoved);
            }
            ExperienceUtils.addPlayerXP(player, xpForPlayer);
            if (world.isClientSide()) {
                world.playSound(player, player.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.05f, this.getPitch(world.getRandom(), stack));
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public float getPitch(RandomSource rand, ItemStack stack) {
        return 0.4f + (rand.nextFloat() - rand.nextFloat()) * 0.1f + (float)this.getCurrentExperienceStored(stack) / (float)this.getMaxExperienceStored(stack) * 0.5f;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.BLOCK;
    }

    @Override
    public int getMaxExperienceStored(ItemStack stack) {
        return (Integer)ConfigSettings.CRYSTAL_EXPERIENCE_STORAGE.get();
    }

    @Override
    public int getCurrentExperienceStored(ItemStack stack) {
        return (Integer)stack.getOrDefault(Registration.EXPERIENCE_DATA, (Object)0);
    }

    @Override
    public int extractExperience(ItemStack stack, int maxExtract, boolean simulate) {
        int experience = this.getCurrentExperienceStored(stack);
        int experienceExtracted = Math.min(experience, maxExtract);
        if (!simulate) {
            stack.set(Registration.EXPERIENCE_DATA, (Object)(experience -= experienceExtracted));
        }
        return experienceExtracted;
    }

    @Override
    public int receiveExperience(ItemStack stack, int maxReceive, boolean simulate) {
        int experience = this.getCurrentExperienceStored(stack);
        int experienceReceived = Math.min(this.getMaxExperienceStored(stack) - experience, maxReceive);
        if (!simulate) {
            stack.set(Registration.EXPERIENCE_DATA, (Object)(experience += experienceReceived));
        }
        return experienceReceived;
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return true;
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        return Math.round((float)this.getCurrentExperienceStored(stack) / (float)this.getMaxExperienceStored(stack) * 13.0f);
    }

    public int getBarColor(@NotNull ItemStack stack) {
        float f = Math.max(0.0f, ((float)this.getMaxExperienceStored(stack) - (float)this.getCurrentExperienceStored(stack)) / (float)this.getMaxExperienceStored(stack));
        return Mth.hsvToRgb((float)0.4f, (float)(1.0f - f), (float)(1.0f - f / 2.0f));
    }

    public boolean isDamageable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return this.getCurrentExperienceStored(stack) > 0;
    }

    public boolean isBookEnchantable(@NotNull ItemStack stack, @NotNull ItemStack book) {
        return false;
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isValidRepairItem(@NotNull ItemStack toRepair, @NotNull ItemStack repair) {
        return false;
    }

    public boolean isRepairable(@NotNull ItemStack stack) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"message.crystal_gem_item.1").withStyle(ChatFormatting.BLUE));
            tooltipComponents.add((Component)Component.translatable((String)"message.crystal_gem_item.2").withStyle(ChatFormatting.BLUE));
        } else {
            CompUtils.addShiftInfo(tooltipComponents);
        }
        DecimalFormat df = new DecimalFormat("#,###");
        String stored = df.format(this.getCurrentExperienceStored(stack)) + "/" + df.format(this.getMaxExperienceStored(stack));
        int levels = ExperienceUtils.getLevelForExperience(this.getCurrentExperienceStored(stack));
        tooltipComponents.add((Component)Component.translatable((String)"message.crystal_gem_item.3", (Object[])new Object[]{stored, levels}).withStyle(ChatFormatting.GREEN));
    }
}

