/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.furnacemk2.furnace.itemhandlers;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import vapourdrive.furnacemk2.FurnaceMk2;
import vapourdrive.furnacemk2.furnace.FurnaceMk2Tile;
import vapourdrive.furnacemk2.utils.FurnaceUtils;
import vapourdrive.vapourware.shared.base.itemhandlers.IngredientHandler;

public class FurnaceIngredientHandler
extends IngredientHandler {
    public FurnaceIngredientHandler(FurnaceMk2Tile tile, int size) {
        super((BlockEntity)tile, size);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        Level world = this.tile.getLevel();
        assert (world != null);
        return FurnaceUtils.canSmelt(stack, world);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.getStackInSlot(slot).getCount() == amount) {
            FurnaceMk2.debugLog("slot count: " + this.getStackInSlot(slot).getCount() + ", amount: " + amount);
            Objects.requireNonNull(this.tile.getLevel()).setBlock(this.tile.getBlockPos(), (BlockState)this.tile.getBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
        return super.extractItem(slot, amount, simulate);
    }
}

