/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.furnacemk2.furnace;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vapourdrive.furnacemk2.FurnaceMk2;
import vapourdrive.furnacemk2.config.ConfigSettings;
import vapourdrive.furnacemk2.furnace.FurnaceData;
import vapourdrive.furnacemk2.furnace.FurnaceMk2Menu;
import vapourdrive.furnacemk2.furnace.itemhandlers.FurnaceAugmentHandler;
import vapourdrive.furnacemk2.furnace.itemhandlers.FurnaceExperienceHandler;
import vapourdrive.furnacemk2.furnace.itemhandlers.FurnaceIngredientHandler;
import vapourdrive.furnacemk2.items.IExperienceStorage;
import vapourdrive.furnacemk2.setup.Registration;
import vapourdrive.furnacemk2.utils.FurnaceUtils;
import vapourdrive.vapourware.shared.base.AbstractBaseFuelUserTile;
import vapourdrive.vapourware.shared.base.ITickingContainer;
import vapourdrive.vapourware.shared.base.itemhandlers.FuelHandler;
import vapourdrive.vapourware.shared.base.itemhandlers.OutputHandler;
import vapourdrive.vapourware.shared.utils.MachineUtils;

public class FurnaceMk2Tile
extends AbstractBaseFuelUserTile
implements MenuProvider {
    private final FurnaceAugmentHandler augmentHandler = new FurnaceAugmentHandler(this, AUGMENT_SLOTS.length);
    private final FuelHandler fuelHandler = new FuelHandler((AbstractBaseFuelUserTile)this, FUEL_SLOT.length);
    private final FurnaceIngredientHandler ingredientHandler = new FurnaceIngredientHandler(this, INPUT_SLOT.length);
    private final FurnaceExperienceHandler experienceHandler = new FurnaceExperienceHandler(this, EXPERIENCE_OUTPUT_SLOTS.length);
    private final OutputHandler outputHandler = new OutputHandler((BlockEntity)this, OUTPUT_SLOTS.length);
    private final CombinedInvWrapper combined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.augmentHandler, this.fuelHandler, this.ingredientHandler, this.outputHandler, this.experienceHandler});
    private ItemStack lastSmelting = ItemStack.EMPTY;
    public static final int maxExp = 50000;
    public int wait = 20;
    private ItemStack currentResult = ItemStack.EMPTY;
    private ItemStack currentIngredient = ItemStack.EMPTY;
    public final FurnaceData furnaceData = new FurnaceData();
    public static final int[] AUGMENT_SLOTS = new int[]{0, 1, 2};
    public static final int[] FUEL_SLOT = new int[]{0};
    public static final int[] INPUT_SLOT = new int[]{0};
    public static final int[] OUTPUT_SLOTS = new int[]{0, 1, 2, 3};
    public static final int[] EXPERIENCE_OUTPUT_SLOTS = new int[]{0};

    public FurnaceMk2Tile(BlockPos pos, BlockState state) {
        super(Registration.FURNACEMK2_TILE.get(), pos, state, 15000000, 100, new int[]{0, 1, 2, 3});
    }

    public void tickServer(BlockState state) {
        super.tickServer(state);
        ItemStack ingredient = this.getStackInSlot(MachineUtils.Area.INGREDIENT_1, 0);
        if (!this.lastSmelting.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)ingredient, (ItemStack)this.lastSmelting)) {
            this.furnaceData.set(FurnaceData.Data.COOK_PROGRESS, 0);
        }
        this.lastSmelting = ingredient.copy();
        if (!ingredient.isEmpty()) {
            this.doCookProcesses(ingredient, state);
        }
        this.doExperienceItemProcesses();
    }

    private void doCookProcesses(ItemStack ingredient, BlockState state) {
        if (this.furnaceData.get(FurnaceData.Data.COOK_PROGRESS) == 0) {
            if (this.currentResult.isEmpty()) {
                this.currentResult = FurnaceUtils.getSmeltingResultForItem(this.level, ingredient);
                this.currentIngredient = ingredient;
                this.furnaceData.set(FurnaceData.Data.COOK_MAX, FurnaceUtils.getCookTime(this.level, ingredient));
            }
            if (MachineUtils.pushOutput((ItemStack)this.currentResult, (boolean)true, (ITickingContainer)this) >= 1 && this.furnaceData.get(FurnaceData.Data.FUEL) >= this.furnaceData.get(FurnaceData.Data.COOK_MAX)) {
                assert (this.level != null);
                this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)), 3);
                this.setChanged();
                this.progressCook();
            }
        } else if (this.furnaceData.get(FurnaceData.Data.COOK_PROGRESS) >= 0) {
            this.progressCook();
            if (this.furnaceData.get(FurnaceData.Data.COOK_PROGRESS) >= this.furnaceData.get(FurnaceData.Data.COOK_MAX)) {
                if (MachineUtils.pushOutput((ItemStack)this.currentResult, (boolean)false, (ITickingContainer)this) == -1) {
                    FurnaceMk2.debugLog("experience push");
                    this.depositExperienceFromStack(ingredient);
                    this.removeFromSlot(MachineUtils.Area.INGREDIENT_1, 0, 1, false);
                    ItemStack remainingIngredient = this.getStackInSlot(MachineUtils.Area.INGREDIENT_1, 0);
                    if (remainingIngredient.isEmpty()) {
                        this.currentIngredient = ItemStack.EMPTY;
                        this.currentResult = ItemStack.EMPTY;
                    } else if (!ItemStack.isSameItemSameComponents((ItemStack)remainingIngredient, (ItemStack)this.currentIngredient)) {
                        this.currentResult = ItemStack.EMPTY;
                        this.furnaceData.set(FurnaceData.Data.COOK_MAX, 0);
                    }
                    if (remainingIngredient.isEmpty() || this.furnaceData.get(FurnaceData.Data.FUEL) < this.furnaceData.get(FurnaceData.Data.COOK_MAX)) {
                        assert (this.level != null);
                        this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)), 3);
                        this.setChanged();
                    }
                }
                this.furnaceData.set(FurnaceData.Data.COOK_PROGRESS, 0);
            }
        }
    }

    private void doExperienceItemProcesses() {
        Item item;
        ItemStack experienceStorage = this.getStackInSlot(MachineUtils.Area.INGREDIENT_2, 0);
        if (!experienceStorage.isEmpty() && (item = experienceStorage.getItem()) instanceof IExperienceStorage) {
            IExperienceStorage xpStack = (IExperienceStorage)item;
            if (this.furnaceData.get(FurnaceData.Data.EXPERIENCE) >= 100) {
                this.extractExperience(experienceStorage);
            }
            if (xpStack.getCurrentExperienceStored(experienceStorage) >= xpStack.getMaxExperienceStored(experienceStorage)) {
                FurnaceMk2.debugLog("Pushing output for full experience crystal");
                if (MachineUtils.pushOutput((ItemStack)experienceStorage, (boolean)false, (ITickingContainer)this) == -1) {
                    this.removeFromSlot(MachineUtils.Area.INGREDIENT_2, 0, 1, false);
                }
            }
        }
    }

    public void extractExperience(ItemStack stack) {
        IExperienceStorage xpStack = (IExperienceStorage)stack.getItem();
        int toSend = xpStack.receiveExperience(stack, 1, true);
        if (toSend == 1) {
            xpStack.receiveExperience(stack, 1, false);
            this.furnaceData.set(FurnaceData.Data.EXPERIENCE, this.furnaceData.get(FurnaceData.Data.EXPERIENCE) - 100);
        }
    }

    public void progressCook() {
        double speed = this.getSpeedMultiplier();
        if (this.furnaceData.get(FurnaceData.Data.FUEL) > 0) {
            this.furnaceData.set(FurnaceData.Data.COOK_PROGRESS, this.furnaceData.get(FurnaceData.Data.COOK_PROGRESS) + (int)(100.0 * speed));
            this.furnaceData.set(FurnaceData.Data.FUEL, this.furnaceData.get(FurnaceData.Data.FUEL) - (int)(100.0 * speed));
        }
    }

    private void depositExperienceFromStack(ItemStack ingredient) {
        double adjustment = this.getExperienceMultiplier();
        int toAdd = (int)((double)(FurnaceUtils.getExperience(this.level, ingredient) * 100.0f) * adjustment);
        FurnaceMk2.debugLog("adding xp: " + toAdd);
        this.addExperience(toAdd);
    }

    public void addExperience(int toAdd) {
        FurnaceMk2.debugLog("current xp: " + this.furnaceData.get(FurnaceData.Data.EXPERIENCE));
        this.furnaceData.set(FurnaceData.Data.EXPERIENCE, Math.min(this.furnaceData.get(FurnaceData.Data.EXPERIENCE) + toAdd, 50000));
    }

    public void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.outputHandler.deserializeNBT(registries, tag.getCompound("invOut"));
        this.augmentHandler.deserializeNBT(registries, tag.getCompound("invAug"));
        this.fuelHandler.deserializeNBT(registries, tag.getCompound("invFuel"));
        this.ingredientHandler.deserializeNBT(registries, tag.getCompound("invIngr"));
        this.experienceHandler.deserializeNBT(registries, tag.getCompound("invExp"));
        this.furnaceData.set(FurnaceData.Data.COOK_PROGRESS, tag.getInt("cookProgress"));
        this.furnaceData.set(FurnaceData.Data.COOK_MAX, tag.getInt("cookMax"));
        this.furnaceData.set(FurnaceData.Data.EXPERIENCE, tag.getInt("experience"));
        this.wait = tag.getInt("wait");
    }

    public void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("invOut", (Tag)this.outputHandler.serializeNBT(registries));
        tag.put("invAug", (Tag)this.augmentHandler.serializeNBT(registries));
        tag.put("invFuel", (Tag)this.fuelHandler.serializeNBT(registries));
        tag.put("invIngr", (Tag)this.ingredientHandler.serializeNBT(registries));
        tag.put("invExp", (Tag)this.experienceHandler.serializeNBT(registries));
        tag.putInt("cookProgress", this.furnaceData.get(FurnaceData.Data.COOK_PROGRESS));
        tag.putInt("cookMax", this.furnaceData.get(FurnaceData.Data.COOK_MAX));
        tag.putInt("experience", this.furnaceData.get(FurnaceData.Data.EXPERIENCE));
        tag.putInt("wait", this.wait);
    }

    public IItemHandler getItemHandler(@Nullable Direction side) {
        if (side == Direction.DOWN) {
            return this.outputHandler;
        }
        return this.combined;
    }

    public double getSpeedMultiplier() {
        return this.getStackInSlot(MachineUtils.Area.AUGMENT, 1).isEmpty() ? (Double)ConfigSettings.FURNACE_BASE_SPEED.get() : (Double)ConfigSettings.FURNACE_UPGRADED_SPEED.get() * (Double)ConfigSettings.FURNACE_BASE_SPEED.get();
    }

    public double getEfficiencyMultiplier() {
        return this.getStackInSlot(MachineUtils.Area.AUGMENT, 0).isEmpty() ? (Double)ConfigSettings.FURNACE_BASE_EFFICIENCY.get() : (Double)ConfigSettings.FURNACE_UPGRADED_EFFICIENCY.get() * (Double)ConfigSettings.FURNACE_BASE_EFFICIENCY.get();
    }

    public double getExperienceMultiplier() {
        return this.getStackInSlot(MachineUtils.Area.AUGMENT, 2).isEmpty() ? (Double)ConfigSettings.FURNACE_BASE_EXPERIENCE.get() : (Double)ConfigSettings.FURNACE_UPGRADED_EXPERIENCE.get() * (Double)ConfigSettings.FURNACE_BASE_EXPERIENCE.get();
    }

    public int getCurrentExp() {
        return this.furnaceData.get(FurnaceData.Data.EXPERIENCE);
    }

    public static int getMaxExp() {
        return 50000;
    }

    public int getCurrentFuel() {
        return this.furnaceData.get(FurnaceData.Data.FUEL);
    }

    public boolean addFuel(int toAdd, boolean simulate) {
        if (toAdd + this.getCurrentFuel() > this.getMaxFuel()) {
            return false;
        }
        if (!simulate) {
            this.furnaceData.set(FurnaceData.Data.FUEL, this.getCurrentFuel() + toAdd);
        }
        return true;
    }

    public boolean consumeFuel(int toConsume, boolean simulate) {
        if (this.getCurrentFuel() < toConsume) {
            return false;
        }
        if (!simulate) {
            this.furnaceData.set(FurnaceData.Data.FUEL, this.getCurrentFuel() - toConsume);
        }
        return true;
    }

    public FurnaceData getFurnaceData() {
        return this.furnaceData;
    }

    public ItemStack getStackInSlot(MachineUtils.Area area, int index) {
        return switch (area) {
            case MachineUtils.Area.AUGMENT -> this.augmentHandler.getStackInSlot(AUGMENT_SLOTS[index]);
            case MachineUtils.Area.INGREDIENT_1 -> this.ingredientHandler.getStackInSlot(INPUT_SLOT[index]);
            case MachineUtils.Area.INGREDIENT_2 -> this.experienceHandler.getStackInSlot(EXPERIENCE_OUTPUT_SLOTS[index]);
            case MachineUtils.Area.FUEL -> this.fuelHandler.getStackInSlot(FUEL_SLOT[index]);
            case MachineUtils.Area.OUTPUT -> this.outputHandler.getStackInSlot(OUTPUT_SLOTS[index]);
            default -> ItemStack.EMPTY;
        };
    }

    public void removeFromSlot(MachineUtils.Area area, int index, int amount, boolean simulate) {
        switch (area) {
            case AUGMENT: {
                this.augmentHandler.extractItem(AUGMENT_SLOTS[index], amount, simulate);
                break;
            }
            case INGREDIENT_1: {
                this.ingredientHandler.extractItem(INPUT_SLOT[index], amount, simulate);
                break;
            }
            case INGREDIENT_2: {
                this.experienceHandler.extractItem(EXPERIENCE_OUTPUT_SLOTS[index], amount, simulate);
                break;
            }
            case FUEL: {
                this.fuelHandler.extractItem(FUEL_SLOT[index], amount, simulate);
                break;
            }
            case OUTPUT: {
                this.outputHandler.extractItem(OUTPUT_SLOTS[index], amount, simulate);
            }
        }
    }

    public ItemStack insertToSlot(MachineUtils.Area area, int index, ItemStack stack, boolean simulate) {
        return switch (area) {
            case MachineUtils.Area.AUGMENT -> this.augmentHandler.insertItem(AUGMENT_SLOTS[index], stack, simulate);
            case MachineUtils.Area.INGREDIENT_1 -> this.ingredientHandler.insertItem(INPUT_SLOT[index], stack, simulate);
            case MachineUtils.Area.INGREDIENT_2 -> this.experienceHandler.insertItem(EXPERIENCE_OUTPUT_SLOTS[index], stack, simulate);
            case MachineUtils.Area.FUEL -> this.fuelHandler.insertItem(FUEL_SLOT[index], stack, simulate);
            case MachineUtils.Area.OUTPUT -> this.outputHandler.insertItem(OUTPUT_SLOTS[index], stack, simulate, true);
            default -> ItemStack.EMPTY;
        };
    }

    public ContainerData getContainerData() {
        return this.getFurnaceData();
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"furnacemk2.furnacemk2");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory inventory, @NotNull Player player) {
        return new FurnaceMk2Menu(id, this.level, this.worldPosition, player.getInventory(), player, this.getFurnaceData());
    }
}

