/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.furnacemk2.furnace;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;
import vapourdrive.furnacemk2.furnace.FurnaceMk2Menu;
import vapourdrive.vapourware.shared.base.AbstractBaseMachineMenu;
import vapourdrive.vapourware.shared.base.AbstractBaseMachineScreen;
import vapourdrive.vapourware.shared.utils.CompUtils;
import vapourdrive.vapourware.shared.utils.DeferredComponent;

public class FurnaceMk2Screen
extends AbstractBaseMachineScreen<FurnaceMk2Menu> {
    private final FurnaceMk2Menu container;
    static final int COOK_BAR_XPOS = 67;
    static final int COOK_BAR_YPOS = 21;
    static final int COOK_BAR_ICONX = 184;
    static final int COOK_BAR_ICONY = 24;
    static final int COOK_BAR_WIDTH = 24;
    static final int COOK_BAR_HEIGHT = 16;
    static final int EXP_XPOS = 94;
    static final int EXP_YPOS = 56;
    static final int EXP_ICONX = 184;
    static final int EXP_ICONY = 41;
    static final int EXP_HEIGHT = 10;
    static final int EXP_WIDTH = 49;
    DecimalFormat exp_f = new DecimalFormat("#,###.##");

    public FurnaceMk2Screen(FurnaceMk2Menu container, Inventory inv, Component name) {
        super((AbstractBaseMachineMenu)container, inv, name, new DeferredComponent("furnacemk2", "furnacemk2"), 33, 17, 52, 158, 6, 1, true);
        this.container = container;
    }

    protected void renderBg(@NotNull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(graphics, partialTicks, mouseX, mouseY);
        int l = (int)(this.container.getCookProgress() * 24.0f);
        graphics.blit(this.GUI, this.leftPos + 67, this.topPos + 21, 184, 24, l + 1, 16);
        int k = (int)(this.container.getExperiencePercentage() * 49.0f);
        graphics.blit(this.GUI, this.leftPos + 94, this.topPos + 56, 184, 41, k, 10);
    }

    protected void renderTooltip(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderTooltip(graphics, mouseX, mouseY);
        boolean notCarrying = ((FurnaceMk2Menu)this.menu).getCarried().isEmpty();
        ArrayList<MutableComponent> hoveringText = new ArrayList<MutableComponent>();
        if (notCarrying && FurnaceMk2Screen.isInRect((int)(this.leftPos + 67), (int)(this.topPos + 21), (int)24, (int)16, (int)mouseX, (int)mouseY) && this.container.getCookProgress() > 0.0f) {
            int cookPercentage = (int)(this.container.getCookProgress() * 100.0f);
            hoveringText.add(Component.literal((String)"Progress: ").append(cookPercentage + "%"));
        }
        if (notCarrying && FurnaceMk2Screen.isInRect((int)(this.leftPos + 94), (int)(this.topPos + 56), (int)49, (int)10, (int)mouseX, (int)mouseY)) {
            float experience = (float)this.container.getExperienceStored() / 100.0f;
            hoveringText.add(Component.literal((String)"Exp: ").append(this.exp_f.format(experience) + "/" + this.exp_f.format(this.container.getMaxExp() / 100)));
        }
        if (!hoveringText.isEmpty()) {
            graphics.renderComponentTooltip(this.font, hoveringText, mouseX, mouseY);
        }
    }

    protected void getAdditionalInfoHover(List<Component> hoveringText) {
        super.getAdditionalInfoHover(hoveringText);
        hoveringText.add((Component)CompUtils.getComp((String)this.comp.getMod(), (String)(this.comp.getTail() + ".wrench")).withStyle(ChatFormatting.GOLD));
    }
}

