/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.furnacemk2.furnace;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import vapourdrive.furnacemk2.FurnaceMk2;
import vapourdrive.furnacemk2.furnace.FurnaceData;
import vapourdrive.furnacemk2.furnace.FurnaceMk2Tile;
import vapourdrive.furnacemk2.furnace.slots.SlotCore;
import vapourdrive.furnacemk2.furnace.slots.SlotExperience;
import vapourdrive.furnacemk2.furnace.slots.SlotIngredient;
import vapourdrive.furnacemk2.items.IExperienceStorage;
import vapourdrive.furnacemk2.setup.Registration;
import vapourdrive.furnacemk2.utils.FurnaceUtils;
import vapourdrive.vapourware.shared.base.AbstractBaseMachineMenu;
import vapourdrive.vapourware.shared.base.slots.SlotFuel;
import vapourdrive.vapourware.shared.base.slots.SlotOutput;

public class FurnaceMk2Menu
extends AbstractBaseMachineMenu {
    public static final int PLAYER_INVENTORY_XPOS = 8;
    public static final int PLAYER_INVENTORY_YPOS = 84;
    protected final FurnaceMk2Tile tileEntity;

    public FurnaceMk2Menu(int windowId, Level world, BlockPos pos, Inventory inv, Player player, FurnaceData furnaceData) {
        super(windowId, world, pos, inv, player, Registration.FURNACEMK2_MENU.get(), (ContainerData)furnaceData);
        FurnaceMk2Tile furnaceMk2Tile;
        this.tileEntity = (FurnaceMk2Tile)world.getBlockEntity(pos);
        this.addSplitDataSlots(furnaceData);
        this.layoutPlayerInventorySlots(8, 84);
        if (this.tileEntity != null && (furnaceMk2Tile = this.tileEntity) instanceof FurnaceMk2Tile) {
            FurnaceMk2Tile machine = furnaceMk2Tile;
            IItemHandler handler = machine.getItemHandler(null);
            this.addSlot((Slot)new SlotCore(handler, 0, 8, 17, Registration.INSULATION_CORE_ITEM.get()));
            this.addSlot((Slot)new SlotCore(handler, 1, 8, 35, Registration.THERMAL_CORE_ITEM.get()));
            this.addSlot((Slot)new SlotCore(handler, 2, 8, 53, Registration.EXPERIENCE_CORE_ITEM.get()));
            this.addSlot((Slot)new SlotFuel(handler, 3, 49, 53));
            this.addSlot((Slot)new SlotIngredient(handler, 4, 49, 22, this.world));
            this.addSlot((Slot)new SlotOutput(handler, 5, 94, 22));
            this.addSlot((Slot)new SlotOutput(handler, 6, 112, 22));
            this.addSlot((Slot)new SlotOutput(handler, 7, 130, 22));
            this.addSlot((Slot)new SlotOutput(handler, 8, 148, 22));
            this.addSlot((Slot)new SlotExperience(handler, 9, 148, 53));
        }
    }

    public boolean stillValid(@NotNull Player playerIn) {
        return FurnaceMk2Menu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)Objects.requireNonNull(this.tileEntity.getLevel()), (BlockPos)this.tileEntity.getBlockPos()), (Player)this.playerEntity, (Block)((Block)Registration.FURNACEMK2_BLOCK.get()));
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        FurnaceMk2.debugLog("index: " + index);
        if (slot.hasItem()) {
            ItemStack stack = slot.getItem();
            itemstack = stack.copy();
            if (index >= 41 && index <= 45) {
                FurnaceMk2.debugLog("From furnace output");
                if (!this.moveItemStackTo(stack, 0, 36, false)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(stack, itemstack);
            }
            if (index >= 36 && index <= 40) {
                FurnaceMk2.debugLog("From furnace non-output");
                if (!this.moveItemStackTo(stack, 0, 36, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (index <= 35) {
                if ((double)stack.getBurnTime(RecipeType.SMELTING) > 0.0 && !this.moveItemStackTo(stack, 39, 40, false)) {
                    return ItemStack.EMPTY;
                }
                if (FurnaceUtils.canSmelt(stack, this.world)) {
                    FurnaceMk2.debugLog("From Player inventory to smelt slot");
                    if (!this.moveItemStackTo(stack, 40, 41, false)) {
                        return ItemStack.EMPTY;
                    }
                }
                if (!(stack.getItem() != Registration.INSULATION_CORE_ITEM.get() && stack.getItem() != Registration.THERMAL_CORE_ITEM.get() && stack.getItem() != Registration.EXPERIENCE_CORE_ITEM.get() || this.moveItemStackTo(stack, 36, 39, false))) {
                    return ItemStack.EMPTY;
                }
                if (stack.getItem() instanceof IExperienceStorage) {
                    FurnaceMk2.debugLog("From Player inventory to experience slot");
                    if (!this.moveItemStackTo(stack, 45, 46, false)) {
                        return ItemStack.EMPTY;
                    }
                }
                if (index <= 26) {
                    FurnaceMk2.debugLog("From Player inventory to hotbar");
                    if (!this.moveItemStackTo(stack, 27, 36, false)) {
                        return ItemStack.EMPTY;
                    }
                } else {
                    FurnaceMk2.debugLog("From Hotbar to inventory");
                    if (!this.moveItemStackTo(stack, 0, 27, false)) {
                        return ItemStack.EMPTY;
                    }
                }
            }
            if (stack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stack.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, stack);
        }
        return itemstack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getCookProgress() {
        int i = this.machineData.get(FurnaceData.Data.COOK_PROGRESS.ordinal());
        if (i == 0) {
            return 0.0f;
        }
        return (float)i / (float)this.machineData.get(FurnaceData.Data.COOK_MAX.ordinal());
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getExperiencePercentage() {
        int i = this.machineData.get(FurnaceData.Data.EXPERIENCE.ordinal());
        if (i == 0) {
            return 0.0f;
        }
        return (float)i / (float)FurnaceMk2Tile.getMaxExp();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getExperienceStored() {
        return this.machineData.get(FurnaceData.Data.EXPERIENCE.ordinal());
    }

    public int getMaxExp() {
        return FurnaceMk2Tile.getMaxExp();
    }
}

