/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.furnacemk2.furnace;

import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import vapourdrive.furnacemk2.config.ConfigSettings;
import vapourdrive.furnacemk2.furnace.FurnaceMk2Tile;
import vapourdrive.furnacemk2.setup.Registration;
import vapourdrive.vapourware.shared.base.BaseMachineItem;
import vapourdrive.vapourware.shared.utils.DeferredComponent;

public class FurnaceMk2Item
extends BaseMachineItem {
    public FurnaceMk2Item(Block block, Item.Properties properties) {
        super(block, properties, new DeferredComponent("furnacemk2", "furnacemk2.info"));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.literal((String)(this.df.format((Double)ConfigSettings.FURNACE_BASE_SPEED.get() * 100.0) + "% speed")).withStyle(ChatFormatting.BLUE));
        tooltipComponents.add((Component)Component.literal((String)(this.df.format((Double)ConfigSettings.FURNACE_BASE_EXPERIENCE.get() * 100.0) + "% experience")).withStyle(ChatFormatting.BLUE));
        tooltipComponents.add((Component)Component.literal((String)(this.df.format((Double)ConfigSettings.FURNACE_BASE_EFFICIENCY.get() * 100.0) + "% fuel efficiency")).withStyle(ChatFormatting.BLUE));
    }

    protected List<Component> appendAdditionalTagInfo(List<Component> list, CompoundTag tag) {
        float experience = (float)tag.getInt("furnacemk2.exp") / 100.0f;
        DecimalFormat exp_f = new DecimalFormat("#,###.##");
        list.add((Component)Component.literal((String)"Exp: ").append(exp_f.format(experience) + "/" + exp_f.format(FurnaceMk2Tile.getMaxExp() / 100)));
        return list;
    }

    protected void updateAdditional(BlockEntity blockEntity, ItemStack stack) {
        if (blockEntity instanceof FurnaceMk2Tile) {
            FurnaceMk2Tile machine = (FurnaceMk2Tile)blockEntity;
            machine.addExperience((Integer)stack.getOrDefault(Registration.EXPERIENCE_DATA, (Object)0));
        }
        super.updateAdditional(blockEntity, stack);
    }
}

