/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.betterx.wover.util.SortedLinkedList;
import org.jetbrains.annotations.NotNull;

public class PriorityLinkedList<T>
implements Iterable<T>,
Collection<T> {
    public static int DEFAULT_PRIORITY = 1000;
    private final SortedLinkedList<Entry<T>> list = new SortedLinkedList((a, b) -> b.priority - a.priority);

    public boolean add(T value, int priority) {
        return this.list.add(new Entry<T>(value, priority));
    }

    @Override
    public boolean add(T t) {
        return this.list.add(new Entry<T>(t, DEFAULT_PRIORITY));
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> c) {
        return this.addAll(c, DEFAULT_PRIORITY);
    }

    public boolean addAll(@NotNull Collection<? extends T> c, int priority) {
        boolean changed = false;
        for (T e : c) {
            changed |= this.add(e, priority);
        }
        return changed;
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new PriorityLinkedListIterator(this.list.iterator());
    }

    @Override
    @NotNull
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        int i = 0;
        for (Entry entry : this.list) {
            result[i++] = entry.value;
        }
        return result;
    }

    @Override
    @NotNull
    public <T1> T1[] toArray(@NotNull T1[] a) {
        if (a.length < this.size()) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        }
        int i = 0;
        Object[] result = a;
        for (Entry entry : this.list) {
            result[i++] = entry.value;
        }
        if (a.length > this.size()) {
            a[this.size()] = null;
        }
        return a;
    }

    public T get(int i) {
        return this.list.get((int)i).value;
    }

    public String toString() {
        return this.list.toString();
    }

    private static class Entry<T> {
        public final T value;
        private final int priority;

        public Entry(T value, int priority) {
            this.value = value;
            this.priority = priority;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Entry) {
                Entry that = (Entry)o;
                return Objects.equals(this.value, that.value);
            }
            if (o != null) {
                return o.equals(this.value);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return this.value.toString() + " - " + this.priority;
        }
    }

    private static class PriorityLinkedListIterator<T>
    implements Iterator<T> {
        private final Iterator<Entry<T>> iterator;

        public PriorityLinkedListIterator(Iterator<Entry<T>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.iterator.next().value;
        }
    }
}

