/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.core.mixin.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.betterx.wover.common.registry.api.CustomRegistryData;
import org.betterx.wover.core.impl.registry.DatapackLoadElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MappedRegistry.class})
public class MappedRegistryMixin
implements CustomRegistryData {
    private final Map<ResourceLocation, Object> wover$custom = new HashMap<ResourceLocation, Object>();

    @Nullable
    public <T> T wover_getData(@NotNull CustomRegistryData.DataKey<T> id) {
        return (T)this.wover$custom.get(id.id);
    }

    @Nullable
    public <T> T wover_computeDataIfAbsent(@NotNull CustomRegistryData.DataKey<T> id, @NotNull Function<ResourceLocation, T> fkt) {
        return (T)this.wover$custom.computeIfAbsent(id.id, fkt);
    }

    public <T> void wover_putData(@NotNull CustomRegistryData.DataKey<T> id, @Nullable T data) {
        this.wover$custom.put(id.id, data);
    }

    @Inject(method={"register"}, at={@At(value="HEAD")}, cancellable=false)
    public <T> void wover_register(ResourceKey<T> resourceKey, T value, RegistrationInfo registrationInfo, CallbackInfoReturnable<Holder.Reference<T>> cir) {
        if (value != null) {
            DatapackLoadElementImpl.didLoadFromDatapack(resourceKey, value);
        }
    }
}

