/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.core.impl.registry;

import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.WritableRegistry;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.betterx.wover.core.api.registry.DatapackRegistryBuilder;
import org.betterx.wover.core.api.registry.DatapackRegistryEntrypoint;
import org.betterx.wover.entrypoint.LibWoverCore;
import org.betterx.wover.util.PriorityLinkedList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class DatapackRegistryBuilderImpl {
    public static final int DEFAULT_PRIORITY = 1000;
    public static final int MAX_READONLY_PRIORITY = -1000;
    private static final PriorityLinkedList<Entry<?>> REGISTRIES = new PriorityLinkedList();
    private static boolean didInitEntrypoints = false;

    public static boolean isRegistered(ResourceLocation registryId) {
        return REGISTRIES.stream().filter(entry -> entry.definesRegistry()).anyMatch(entry -> entry.key.location().equals((Object)registryId));
    }

    public static <T> void register(ResourceKey<? extends Registry<T>> key, Consumer<BootstrapContext<T>> bootstrap) {
        DatapackRegistryBuilderImpl.register(key, bootstrap, 1000);
    }

    public static <T> void register(ResourceKey<? extends Registry<T>> key, Consumer<BootstrapContext<T>> bootstrap, int priority) {
        LibWoverCore.C.log.debug("Adding dynamic registry bootstrap: " + String.valueOf(key.location()));
        REGISTRIES.add(new Entry<T>(key, null, bootstrap), Math.max(-999, priority));
    }

    public static <T> void registerReadOnly(ResourceKey<? extends Registry<T>> key, Consumer<BootstrapContext<T>> bootstrap) {
        DatapackRegistryBuilderImpl.register(key, bootstrap, -1000);
    }

    public static <T> void registerReadOnly(ResourceKey<? extends Registry<T>> key, Consumer<BootstrapContext<T>> bootstrap, int priority) {
        DatapackRegistryBuilderImpl.register(key, bootstrap, Math.min(-1000, Integer.MIN_VALUE + priority));
    }

    public static <T> void register(ResourceKey<? extends Registry<T>> key, Codec<T> elementCodec, Consumer<BootstrapContext<T>> bootstrap) {
        DatapackRegistryBuilderImpl.register(key, elementCodec, 1000, bootstrap);
    }

    public static <T> void register(ResourceKey<? extends Registry<T>> key, Codec<T> elementCodec, int priority, Consumer<BootstrapContext<T>> bootstrap) {
        if (DatapackRegistryBuilderImpl.isRegistered(key.location())) {
            throw new IllegalStateException("Registry with id " + String.valueOf(key.location()) + " was already registered!");
        }
        LibWoverCore.C.log.debug("Adding dynamic registry: " + String.valueOf(key.location()));
        REGISTRIES.add(new Entry<T>(key, elementCodec, bootstrap), priority);
    }

    public static void forEach(BiConsumer<ResourceKey<? extends Registry<?>>, Codec<?>> consumer) {
        DatapackRegistryBuilderImpl.initEntrypoints();
        REGISTRIES.forEach(entry -> consumer.accept(entry.key, entry.elementCodec));
    }

    private static void initEntrypoints() {
        if (didInitEntrypoints) {
            return;
        }
        didInitEntrypoints = true;
        LibWoverCore.C.LOG.verbose("Processing wover.datapack.registry Entrypoints");
        FabricLoader.getInstance().getEntrypoints("wover.datapack.registry", DatapackRegistryEntrypoint.class).forEach(entrypoint -> {
            LibWoverCore.C.LOG.verbose("    - Processing Entrypoint: {}", entrypoint.getClass().getName());
            entrypoint.registerDatapackRegistries();
        });
    }

    @ApiStatus.Internal
    public static <E> void bootstrap(RegistryOps.RegistryInfoLookup registryInfoLookup, ResourceKey<? extends Registry<E>> resourceKey, WritableRegistry<E> writableRegistry) {
        DatapackRegistryBuilderImpl.initEntrypoints();
        LibWoverCore.C.LOG.debug("Bootstrapping registry {}", resourceKey.location());
        REGISTRIES.forEach(entry -> {
            if (entry.key.equals(resourceKey)) {
                LibWoverCore.C.LOG.debug("Calling custom Registry Bootstrap on {}", resourceKey.location());
                entry.bootstrap.accept(entry.getContext(registryInfoLookup, writableRegistry));
            }
        });
    }

    @ApiStatus.Internal
    public static void bootstrap(BiConsumer<ResourceKey<? extends Registry<?>>, RegistrySetBuilder.RegistryBootstrap<? extends Object>> consumer) {
        LibWoverCore.C.LOG.verboseWarning("DID NOT bootstrap VanillaRegistries.");
    }

    private record Entry<T>(ResourceKey<? extends Registry<T>> key, @Nullable Codec<T> elementCodec, Consumer<BootstrapContext<T>> bootstrap) {
        public BootstrapContext<T> getContext(RegistryOps.RegistryInfoLookup registryInfoLookup, WritableRegistry<T> registry) {
            return DatapackRegistryBuilder.makeContext(registryInfoLookup, registry);
        }

        public boolean definesRegistry() {
            return this.elementCodec != null;
        }
    }
}

