/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.core.impl.registry;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import org.betterx.wover.core.api.registry.OnElementLoad;
import org.betterx.wover.util.PriorityLinkedList;
import org.jetbrains.annotations.ApiStatus;

public class DatapackLoadElementImpl {
    public static final int DEFAULT_PRIORITY = 1000;
    public static final int MAX_READONLY_PRIORITY = -1000;
    private static final Map<ResourceKey<Registry<?>>, PriorityLinkedList<OnElementLoad>> WATCHERS = new HashMap();

    public static <E> boolean isRegistered(ResourceKey<Registry<E>> registryId) {
        return WATCHERS.containsKey(registryId);
    }

    public static <E, R extends Registry<E>> PriorityLinkedList<OnElementLoad> getWatchers(ResourceKey<R> registryId) {
        ResourceKey<R> rKey = registryId;
        return WATCHERS.computeIfAbsent(rKey, k -> new PriorityLinkedList());
    }

    public static <E> void register(ResourceKey<Registry<E>> registryKey, OnElementLoad<E> watcher) {
        DatapackLoadElementImpl.getWatchers(registryKey).add(watcher, 1000);
    }

    public static <E> void register(ResourceKey<Registry<E>> registryKey, OnElementLoad<E> watcher, int priority) {
        DatapackLoadElementImpl.getWatchers(registryKey).add(watcher, Math.max(-999, priority));
    }

    @ApiStatus.Internal
    public static <E> void didLoadFromDatapack(ResourceKey<E> elementKey, E element) {
        if (DatapackLoadElementImpl.isRegistered(elementKey.registryKey())) {
            DatapackLoadElementImpl.getWatchers(elementKey.registryKey()).forEach(watcher -> watcher.didLoadFromDatapack(elementKey, element));
        }
    }
}

