/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.core.api.registry;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.betterx.wover.core.api.registry.OnElementLoad;
import org.betterx.wover.core.impl.registry.DatapackLoadElementImpl;
import org.betterx.wover.core.impl.registry.DatapackRegistryBuilderImpl;
import org.jetbrains.annotations.Nullable;

public class DatapackRegistryBuilder {
    public static <T> void register(ResourceKey<? extends Registry<T>> key, Codec<T> elementCodec, Consumer<BootstrapContext<T>> bootstrap) {
        DatapackRegistryBuilderImpl.register(key, elementCodec, bootstrap);
    }

    public static <T> void register(ResourceKey<? extends Registry<T>> key, Codec<T> elementCodec, Consumer<BootstrapContext<T>> bootstrap, int priority) {
        DatapackRegistryBuilderImpl.register(key, elementCodec, priority, bootstrap);
    }

    public static <T> void addBootstrap(ResourceKey<? extends Registry<T>> key, Consumer<BootstrapContext<T>> bootstrap) {
        DatapackRegistryBuilderImpl.register(key, bootstrap);
    }

    public static <T> void addBootstrap(ResourceKey<? extends Registry<T>> key, Consumer<BootstrapContext<T>> bootstrap, int priority) {
        DatapackRegistryBuilderImpl.register(key, bootstrap, priority);
    }

    public static <T> void addReadOnlyBootstrap(ResourceKey<? extends Registry<T>> key, Consumer<BootstrapContext<T>> bootstrap) {
        DatapackRegistryBuilderImpl.registerReadOnly(key, bootstrap);
    }

    public static <T> void addReadOnlyBootstrap(ResourceKey<? extends Registry<T>> key, Consumer<BootstrapContext<T>> bootstrap, int priority) {
        DatapackRegistryBuilderImpl.registerReadOnly(key, bootstrap, priority);
    }

    public static boolean isRegistered(ResourceLocation registryId) {
        return DatapackRegistryBuilderImpl.isRegistered(registryId);
    }

    public static <T> BootstrapContext<T> makeContext(final RegistryOps.RegistryInfoLookup registryInfoLookup, final WritableRegistry<T> registry) {
        return new BootstrapContext<T>(){

            public Holder.Reference<T> register(ResourceKey<T> resourceKey, T object, Lifecycle lifecycle) {
                if (!registry.containsKey(resourceKey)) {
                    return registry.register(resourceKey, object, new RegistrationInfo(Optional.empty(), lifecycle));
                }
                return registry.getHolderOrThrow(resourceKey);
            }

            public Holder.Reference<T> register(ResourceKey<T> resourceKey, T object) {
                if (!registry.containsKey(resourceKey)) {
                    return registry.register(resourceKey, object, RegistrationInfo.BUILT_IN);
                }
                return registry.getHolderOrThrow(resourceKey);
            }

            public <S> HolderGetter<S> lookup(ResourceKey<? extends Registry<? extends S>> resourceKey) {
                return registryInfoLookup.lookup(resourceKey).map(o -> o.getter()).orElse(null);
            }
        };
    }

    public static <T> BootstrapContext<T> makeContext(final @Nullable RegistryAccess access, final WritableRegistry<T> registry) {
        final HolderGetter lookup = access == null ? registry.createRegistrationLookup() : null;
        return new BootstrapContext<T>(){

            public Holder.Reference<T> register(ResourceKey<T> resourceKey, T object, Lifecycle lifecycle) {
                if (!registry.containsKey(resourceKey)) {
                    return registry.register(resourceKey, object, new RegistrationInfo(Optional.empty(), lifecycle));
                }
                return registry.getHolderOrThrow(resourceKey);
            }

            public Holder.Reference<T> register(ResourceKey<T> resourceKey, T object) {
                if (!registry.containsKey(resourceKey)) {
                    return registry.register(resourceKey, object, RegistrationInfo.BUILT_IN);
                }
                return registry.getHolderOrThrow(resourceKey);
            }

            public <S> HolderGetter<S> lookup(ResourceKey<? extends Registry<? extends S>> resourceKey) {
                if (access == null) {
                    if (resourceKey.equals((Object)registry.key())) {
                        return lookup;
                    }
                    return null;
                }
                return access.lookupOrThrow(resourceKey);
            }
        };
    }

    public static <T> ResourceKey<Registry<T>> createRegistryKey(ResourceLocation location) {
        return ResourceKey.createRegistryKey((ResourceLocation)location);
    }

    public static <E> void onElementLoad(ResourceKey<Registry<E>> registryKey, OnElementLoad<E> watcher) {
        DatapackLoadElementImpl.register(registryKey, watcher);
    }

    public static <E> void onElementLoad(ResourceKey<Registry<E>> registryKey, OnElementLoad<E> watcher, int priority) {
        DatapackLoadElementImpl.register(registryKey, watcher, priority);
    }
}

