/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.core.api;

import de.ambertation.wunderlib.utils.Version;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.betterx.wover.core.api.Logger;

public final class ModCore
implements Version.ModVersionProvider {
    private static final HashMap<String, ModCore> cache = new HashMap();
    private final List<ResourceLocation> providedDatapacks = new LinkedList<ResourceLocation>();
    public final Logger LOG;
    public final Logger log;
    public final String modId;
    public final String namespace;
    private final Version modVersion;
    public final ModContainer modContainer;

    private ModCore(String modID, String namespace) {
        this.log = this.LOG = Logger.create(modID);
        this.modId = modID;
        this.namespace = namespace;
        Optional optional = FabricLoader.getInstance().getModContainer(this.modId);
        if (optional.isPresent()) {
            this.modContainer = (ModContainer)optional.get();
            this.modVersion = new Version(this.modContainer.getMetadata().getVersion().toString());
        } else {
            this.modContainer = null;
            this.modVersion = new Version(0, 0, 0);
        }
    }

    public Version getModVersion() {
        return this.modVersion;
    }

    public String getModID() {
        return this.modId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ResourceLocation id(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)name);
    }

    public ResourceLocation convertNamespace(ResourceLocation location) {
        return this.id(location.getPath());
    }

    public <T> ResourceLocation convertNamespace(ResourceKey<T> key) {
        return this.convertNamespace(key.location());
    }

    public ResourceLocation mk(String key) {
        return ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)key);
    }

    public boolean isLoaded() {
        return this.modContainer != null;
    }

    public Stream<ResourceLocation> providedDatapacks() {
        return this.providedDatapacks.stream();
    }

    public ResourceLocation addDatapack(String name, ResourcePackActivationType activationType) {
        ResourceLocation id = this.id(name);
        this.providedDatapacks.add(id);
        ResourceManagerHelper.registerBuiltinResourcePack((ResourceLocation)id, (ModContainer)this.modContainer, (ResourcePackActivationType)activationType);
        return id;
    }

    public ResourceLocation addDatapack(ModCore dependency) {
        return this.addDatapack(dependency.namespace + "_extensions", dependency.isLoaded() ? ResourcePackActivationType.DEFAULT_ENABLED : ResourcePackActivationType.NORMAL);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModCore)) {
            return false;
        }
        ModCore modCore = (ModCore)o;
        return Objects.equals(this.modId, modCore.modId) && Objects.equals(this.namespace, modCore.namespace);
    }

    public int hashCode() {
        return Objects.hash(this.modId, this.namespace);
    }

    public String toString() {
        return "ModCore: " + this.modId + " (" + this.namespace + ")";
    }

    public static ModCore create(String modID) {
        return cache.computeIfAbsent(modID, id -> new ModCore((String)id, (String)id));
    }

    public static ModCore create(String modID, String namespace) {
        return cache.computeIfAbsent(modID, id -> new ModCore((String)id, namespace));
    }

    public static boolean isDatagen() {
        return System.getProperty("fabric-api.datagen") != null;
    }

    public static boolean isDevEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    public static boolean isClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    public static boolean isServer() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER;
    }
}

