/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.block.api.model;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4917;
import net.minecraft.class_4918;
import net.minecraft.class_4922;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4946;
import org.betterx.wover.entrypoint.LibWoverBlock;
import org.jetbrains.annotations.Nullable;

public class WoverBlockModelGenerators {
    public static final class_2960 CROSS = class_2960.method_60656((String)"block/cross");
    public static final class_2960 CUBE = class_2960.method_60656((String)"block/cube");
    public static final class_2960 CUBE_ALL = class_2960.method_60656((String)"block/cube_all");
    public static final class_2960 COMPOSTER = LibWoverBlock.C.id("block/composter");
    public static final class_4942 COMPOSTER_MODEL = new class_4942(Optional.of(COMPOSTER), Optional.empty(), new class_4945[]{class_4945.field_23018, class_4945.field_23014, class_4945.field_23015});
    public final class_4910 vanillaGenerator;
    private final Map<class_2960, class_2960> PARTICLE_ONLY_MODELS = Maps.newHashMap();

    public WoverBlockModelGenerators(class_4910 vanillaGenerator) {
        this.vanillaGenerator = vanillaGenerator;
    }

    public void createObsidianVariants(WoverBlockModelGenerators generators, class_2248 obsidianBlock) {
        class_4946 model = generators.getTextureModels(obsidianBlock, class_4946.field_23036.get(obsidianBlock));
        class_4942 template = model.method_25914();
        class_2960 modelLocation = template.method_25846(obsidianBlock, model.method_25921(), generators.vanillaGenerator.field_22831);
        class_4936.class_4937[] rotations = new class_4936.class_4937[]{class_4936.class_4937.field_22890, class_4936.class_4937.field_22891, class_4936.class_4937.field_22892, class_4936.class_4937.field_22893};
        class_4935[] variants = new class_4935[16];
        int idx = 0;
        for (class_4936.class_4937 rotation : rotations) {
            for (class_4936.class_4937 rotationY : rotations) {
                variants[idx] = class_4935.method_25824().method_25828(class_4936.field_22887, (Object)modelLocation);
                if (rotation != class_4936.class_4937.field_22890) {
                    variants[idx] = variants[idx].method_25828(class_4936.field_22885, (Object)rotation);
                }
                if (rotationY != class_4936.class_4937.field_22890) {
                    variants[idx] = variants[idx].method_25828(class_4936.field_22886, (Object)rotationY);
                }
                ++idx;
            }
        }
        generators.acceptBlockState((class_4917)class_4925.method_25771((class_2248)obsidianBlock, (class_4935[])variants));
    }

    public void acceptBlockState(class_4917 blockStateGenerator) {
        this.vanillaGenerator.field_22830.accept(blockStateGenerator);
    }

    public void acceptModelOutput(class_2960 id, Supplier<JsonElement> supplier) {
        this.vanillaGenerator.field_22831.accept(id, supplier);
    }

    public void delegateItemModel(class_2248 block) {
        this.vanillaGenerator.method_25623(block, class_4944.method_25860((class_2248)block));
    }

    public void delegateItemModel(class_2248 block, class_2960 resourceLocation) {
        this.vanillaGenerator.method_25623(block, resourceLocation);
    }

    public class_4946 getTextureModels(class_2248 block, class_4946 defaultModel) {
        return this.vanillaGenerator.field_28551.getOrDefault(block, defaultModel);
    }

    public Builder modelFor(class_2248 block) {
        class_4946 texturedModel = this.getTextureModels(block, class_4946.field_23036.get(block));
        return this.modelFor(texturedModel);
    }

    public Builder modelFor(class_4946 texturedModel) {
        return new Builder(texturedModel, texturedModel.method_25921());
    }

    public Builder modelFor(class_4946 texturedModel, class_4944 textureMapping) {
        return new Builder(texturedModel, textureMapping);
    }

    public Builder modelFor(class_2248 block, class_4944 textureMappingOverride) {
        class_4946 texturedModel = this.getTextureModels(block, class_4946.field_23036.get(block));
        return new Builder(texturedModel, textureMappingOverride);
    }

    public static class_4944 textureMappingOf(class_4945 slotA, class_2960 locationA) {
        return new class_4944().method_25868(slotA, locationA);
    }

    public static class_4944 textureMappingOf(class_4945 slotA, class_2960 locationA, class_4945 slotB, class_2960 locationB) {
        return WoverBlockModelGenerators.textureMappingOf(slotA, locationA).method_25868(slotB, locationB);
    }

    public void createBookshelf(class_2248 shelf, class_2248 planks) {
        class_4944 textureMapping = class_4944.method_25870((class_2960)class_4944.method_25860((class_2248)shelf), (class_2960)class_4944.method_25860((class_2248)planks));
        class_2960 resourceLocation = class_4943.field_22974.method_25846(shelf, textureMapping, this.vanillaGenerator.field_22831);
        this.acceptBlockState((class_4917)class_4910.method_25644((class_2248)shelf, (class_2960)resourceLocation));
    }

    public void createLadder(class_2248 ladderBlock) {
        this.vanillaGenerator.method_25708(ladderBlock);
        this.vanillaGenerator.method_25600(ladderBlock);
    }

    public class_2960 particleOnlyModel(class_2248 block) {
        class_2960 name = class_4941.method_25842((class_2248)block).method_48331("_particles");
        if (name.method_12836().equals("minecraft")) {
            name = LibWoverBlock.C.mk(name.method_12832());
        }
        class_2960 finalName = name;
        return this.PARTICLE_ONLY_MODELS.computeIfAbsent(name, n -> class_4943.field_22908.method_25852(finalName, new class_4944().method_25868(class_4945.field_23012, class_4944.method_25860((class_2248)block)), this.vanillaGenerator.field_22831));
    }

    public void createSign(class_2248 baseBlock, class_2248 signBlock, class_2248 wallSignBlock) {
        class_2960 particleLocation = this.particleOnlyModel(baseBlock);
        this.acceptBlockState((class_4917)class_4910.method_25644((class_2248)signBlock, (class_2960)particleLocation));
        this.acceptBlockState((class_4917)class_4910.method_25644((class_2248)wallSignBlock, (class_2960)particleLocation));
        this.vanillaGenerator.method_25537(signBlock.method_8389());
        this.vanillaGenerator.method_25540(wallSignBlock);
    }

    public void createHangingSign(class_2248 baseBlock, class_2248 hangingSignBlock, class_2248 wallHangingSignBlock) {
        class_2960 resourceLocation = this.particleOnlyModel(baseBlock);
        this.acceptBlockState((class_4917)class_4910.method_25644((class_2248)hangingSignBlock, (class_2960)resourceLocation));
        this.acceptBlockState((class_4917)class_4910.method_25644((class_2248)wallHangingSignBlock, (class_2960)resourceLocation));
        this.vanillaGenerator.method_25537(hangingSignBlock.method_8389());
        this.vanillaGenerator.method_25540(wallHangingSignBlock);
    }

    public void createBarrel(class_2248 barrelBlock) {
        class_2960 resourceLocation = class_4944.method_25866((class_2248)barrelBlock, (String)"_top_open");
        this.acceptBlockState((class_4917)class_4925.method_25769((class_2248)barrelBlock).method_25775(this.vanillaGenerator.method_25675()).method_25775((class_4926)class_4926.method_25783((class_2769)class_2741.field_12537).method_25793((Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4946.field_23040.method_25923(barrelBlock, this.vanillaGenerator.field_22831))).method_25793((Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4946.field_23040.get(barrelBlock).method_25917(textureMapping -> textureMapping.method_25868(class_4945.field_23015, resourceLocation)).method_25915(barrelBlock, "_open", this.vanillaGenerator.field_22831)))));
    }

    public void createComposter(class_2248 composterBlock) {
        class_4944 mapping = new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)composterBlock, (String)"_side")).method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)composterBlock, (String)"_top")).method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)composterBlock, (String)"_bottom"));
        class_2960 location = COMPOSTER_MODEL.method_25846(composterBlock, mapping, this.vanillaGenerator.field_22831);
        this.acceptBlockState((class_4917)class_4922.method_25758((class_2248)composterBlock).method_25763(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)location)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_17586, (Comparable)Integer.valueOf(1)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4944.method_25866((class_2248)class_2246.field_17563, (String)"_contents1"))).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_17586, (Comparable)Integer.valueOf(2)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4944.method_25866((class_2248)class_2246.field_17563, (String)"_contents2"))).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_17586, (Comparable)Integer.valueOf(3)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4944.method_25866((class_2248)class_2246.field_17563, (String)"_contents3"))).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_17586, (Comparable)Integer.valueOf(4)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4944.method_25866((class_2248)class_2246.field_17563, (String)"_contents4"))).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_17586, (Comparable)Integer.valueOf(5)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4944.method_25866((class_2248)class_2246.field_17563, (String)"_contents5"))).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_17586, (Comparable)Integer.valueOf(6)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4944.method_25866((class_2248)class_2246.field_17563, (String)"_contents6"))).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_17586, (Comparable)Integer.valueOf(7)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4944.method_25866((class_2248)class_2246.field_17563, (String)"_contents7"))).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_17586, (Comparable)Integer.valueOf(8)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4944.method_25866((class_2248)class_2246.field_17563, (String)"_contents_ready"))));
    }

    public void createBlockTopSideBottom(class_2248 bottomBlock, class_2248 coverBlock, boolean withVariants) {
        class_4944 mapping = new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)coverBlock, (String)"_side")).method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)coverBlock, (String)"_top")).method_25868(class_4945.field_23014, class_4944.method_25860((class_2248)bottomBlock));
        class_2960 location = class_4943.field_22977.method_25846(coverBlock, mapping, this.vanillaGenerator.field_22831);
        if (withVariants) {
            this.acceptBlockState((class_4917)WoverBlockModelGenerators.randomTopModelVariant(coverBlock, location));
        } else {
            this.acceptBlockState((class_4917)class_4910.method_25644((class_2248)coverBlock, (class_2960)location));
        }
    }

    public void createCubeModel(class_2248 block) {
        class_4946 model = class_4946.field_23036.get(block);
        class_4944 mapping = this.getTextureModels(block, model).method_25921();
        class_2960 location = model.method_25914().method_25846(block, mapping, this.vanillaGenerator.field_22831);
        this.acceptBlockState((class_4917)class_4910.method_25644((class_2248)block, (class_2960)location));
    }

    public void createPressurePlate(class_2248 plateBlock, class_2960 textureLocation) {
        this.createPressurePlate(plateBlock, new class_4944().method_25868(class_4945.field_23011, textureLocation));
    }

    public void createPressurePlate(class_2248 materialBlock, class_2248 plateBlock) {
        this.createPressurePlate(plateBlock, this.getTextureModels(plateBlock, class_4946.field_23036.get(materialBlock)).method_25921());
    }

    private void createPressurePlate(class_2248 plateBlock, class_4944 mapping) {
        List<class_2960> locations = Stream.of(class_4943.field_22906, class_4943.field_22907).map(template -> template.method_25846(plateBlock, mapping, this.vanillaGenerator.field_22831)).toList();
        this.acceptBlockState(class_4910.method_25673((class_2248)plateBlock, (class_2960)locations.get(0), (class_2960)locations.get(1)));
    }

    public void createButton(class_2248 buttonBlock, class_2960 textureLocation) {
        this.createButton(buttonBlock, new class_4944().method_25868(class_4945.field_23011, textureLocation));
    }

    public void createButton(class_2248 materialBlock, class_2248 buttonBlock) {
        this.createButton(buttonBlock, this.getTextureModels(buttonBlock, class_4946.field_23036.get(materialBlock)).method_25921());
    }

    private void createButton(class_2248 buttonBlock, class_4944 mapping) {
        List<class_2960> locations = Stream.of(class_4943.field_22981, class_4943.field_22982).map(template -> template.method_25846(buttonBlock, mapping, this.vanillaGenerator.field_22831)).toList();
        this.acceptBlockState(class_4910.method_25654((class_2248)buttonBlock, (class_2960)locations.get(0), (class_2960)locations.get(1)));
        this.createItemModel(buttonBlock, class_4943.field_22983, mapping);
    }

    public void createFence(class_2248 fenceBlock, class_2960 textureLocation) {
        this.createFence(fenceBlock, new class_4944().method_25868(class_4945.field_23011, textureLocation));
    }

    public void createFence(class_2248 materialBlock, class_2248 fenceBlock) {
        this.createFence(fenceBlock, this.getTextureModels(fenceBlock, class_4946.field_23036.get(materialBlock)).method_25921());
    }

    public void createFence(class_2248 fenceBlock, class_4944 mapping) {
        List<class_2960> locations = Stream.of(class_4943.field_22988, class_4943.field_22989).map(template -> template.method_25846(fenceBlock, mapping, this.vanillaGenerator.field_22831)).toList();
        this.acceptBlockState(class_4910.method_25661((class_2248)fenceBlock, (class_2960)locations.get(0), (class_2960)locations.get(1)));
        this.createInventoryModel(fenceBlock, class_4943.field_22990, mapping);
    }

    public void createFenceGate(class_2248 gateBlock, class_2960 textureLocation) {
        this.createFence(gateBlock, new class_4944().method_25868(class_4945.field_23011, textureLocation));
    }

    public void createFenceGate(class_2248 materialBlock, class_2248 gateBlock) {
        this.createFenceGate(gateBlock, this.getTextureModels(gateBlock, class_4946.field_23036.get(materialBlock)).method_25921());
    }

    public void createFenceGate(class_2248 gateBlock, class_4944 mapping) {
        List<class_2960> locations = Stream.of(class_4943.field_22996, class_4943.field_22995, class_4943.field_22905, class_4943.field_22904).map(template -> template.method_25846(gateBlock, mapping, this.vanillaGenerator.field_22831)).toList();
        this.acceptBlockState(class_4910.method_25626((class_2248)gateBlock, (class_2960)locations.get(0), (class_2960)locations.get(1), (class_2960)locations.get(2), (class_2960)locations.get(3), (boolean)true));
    }

    public void createStairs(class_2248 stairBlock, class_2960 topTextureLocation, class_2960 sideTextureLocation, class_2960 bottomTextureLocation) {
        this.createStairs(stairBlock, new class_4944().method_25868(class_4945.field_23015, topTextureLocation).method_25868(class_4945.field_23018, sideTextureLocation).method_25868(class_4945.field_23014, bottomTextureLocation));
    }

    public void createStairs(class_2248 materialBlock, class_2248 stairBlock) {
        this.createStairs(stairBlock, this.getTextureModels(stairBlock, class_4946.field_23036.get(materialBlock)).method_25921());
    }

    public void createStairsWithModels(class_2248 stairBlock, class_2960 stair, class_2960 outer, class_2960 inner) {
        this.acceptBlockState(class_4910.method_25646((class_2248)stairBlock, (class_2960)inner, (class_2960)stair, (class_2960)outer));
        this.delegateItemModel(stairBlock, stair);
    }

    public void createStairs(class_2248 stairBlock, class_4944 mapping) {
        List<class_2960> locations = Stream.of(class_4943.field_22913, class_4943.field_22912, class_4943.field_22914).map(template -> template.method_25846(stairBlock, mapping, this.vanillaGenerator.field_22831)).toList();
        this.acceptBlockState(class_4910.method_25646((class_2248)stairBlock, (class_2960)locations.get(0), (class_2960)locations.get(1), (class_2960)locations.get(2)));
        this.delegateItemModel(stairBlock, locations.get(1));
    }

    public void createWall(class_2248 materialBlock, class_2248 wallBlock) {
        this.createWall(wallBlock, this.getTextureModels(wallBlock, class_4946.field_23036.get(materialBlock)).method_25921());
    }

    public void createWall(class_2248 wallBlock, class_4944 mapping) {
        List<class_2960> locations = Stream.of(class_4943.field_22991, class_4943.field_22992, class_4943.field_22993).map(template -> template.method_25846(wallBlock, mapping, this.vanillaGenerator.field_22831)).toList();
        this.acceptBlockState(class_4910.method_25636((class_2248)wallBlock, (class_2960)locations.get(0), (class_2960)locations.get(1), (class_2960)locations.get(2)));
        this.createInventoryModel(wallBlock, class_4943.field_22994, mapping);
    }

    public void createSlab(class_2248 slabBlock, class_2248 baseBlock) {
        class_2960 res = class_4944.method_25860((class_2248)baseBlock);
        this.createSlab(slabBlock, baseBlock, new class_4944().method_25868(class_4945.field_23018, res).method_25868(class_4945.field_23014, res).method_25868(class_4945.field_23015, res));
    }

    public void createSlab(class_2248 slabBlock, class_2248 baseBlock, class_4944 mapping) {
        class_2960 fullBlockLocation = class_4941.method_25842((class_2248)baseBlock);
        List<class_2960> locations = Stream.of(class_4943.field_22909, class_4943.field_22910).map(template -> template.method_25846(slabBlock, mapping, this.vanillaGenerator.field_22831)).toList();
        this.acceptBlockState(class_4910.method_25668((class_2248)slabBlock, (class_2960)locations.get(0), (class_2960)locations.get(1), (class_2960)fullBlockLocation));
        this.delegateItemModel(slabBlock, locations.get(0));
    }

    public void createRotatedPillar(class_2248 pillarBlock) {
        class_2960 res = class_4944.method_25860((class_2248)pillarBlock);
        this.createRotatedPillar(pillarBlock, new class_4944().method_25868(class_4945.field_23018, res.method_48331("_side")).method_25868(class_4945.field_23013, res.method_48331("_top")));
    }

    public void createRotatedPillar(class_2248 pillarBlock, class_4944 mapping) {
        class_2960 model = class_4943.field_22974.method_25846(pillarBlock, mapping, this.vanillaGenerator.field_22831);
        this.acceptBlockState(class_4910.method_25653((class_2248)pillarBlock, (class_2960)model));
    }

    private void createInventoryModel(class_2248 wallBlock, class_4942 inventoryModel, class_4944 mapping) {
        this.delegateItemModel(wallBlock, inventoryModel.method_25846(wallBlock, mapping, this.vanillaGenerator.field_22831));
    }

    public void createChest(class_2248 materialBlock, class_2248 chestBlock) {
        class_2960 baseModel = this.particleOnlyModel(materialBlock);
        this.acceptBlockState((class_4917)class_4910.method_25644((class_2248)chestBlock, (class_2960)baseModel));
    }

    public final void createItemModel(class_2248 block, class_4942 template, class_4944 mapping) {
        class_1792 item = block.method_8389();
        if (item != class_1802.field_8162) {
            template.method_25852(class_4941.method_25840((class_1792)item), mapping, this.vanillaGenerator.field_22831);
        }
        this.vanillaGenerator.method_25540(block);
    }

    public void createFlatItem(class_2248 block) {
        this.vanillaGenerator.method_25600(block);
        this.vanillaGenerator.method_25540(block);
    }

    public void createWallItem(class_2248 block, class_2960 textureLocation) {
        this.createInventoryModel(block, class_4943.field_22994, new class_4944().method_25868(class_4945.field_23027, textureLocation));
        this.vanillaGenerator.method_25540(block);
    }

    public void createFlatItem(class_2248 block, @Nullable class_2960 itemLocation) {
        if (itemLocation == null) {
            this.createFlatItem(block);
            return;
        }
        class_1792 item = block.method_8389();
        if (item != class_1802.field_8162) {
            class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)item), class_4944.method_25895((class_2960)itemLocation), this.vanillaGenerator.field_22831);
        }
        this.vanillaGenerator.method_25540(block);
    }

    public static class_4925 randomTopModelVariant(class_2248 block, class_2960 model) {
        return class_4925.method_25771((class_2248)block, (class_4935[])new class_4935[]{class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22890).method_25828(class_4936.field_22888, (Object)false).method_25828(class_4936.field_22889, (Object)1), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)false).method_25828(class_4936.field_22889, (Object)1), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)false).method_25828(class_4936.field_22889, (Object)1), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)false).method_25828(class_4936.field_22889, (Object)1)});
    }

    public BiConsumer<class_2960, Supplier<JsonElement>> modelOutput() {
        return this.vanillaGenerator.field_22831;
    }

    public class Builder {
        private class_2960 fullBlockLocation;
        private final class_4946 model;
        private final class_4944 mapping;
        private final Map<class_4942, class_2960> models = Maps.newHashMap();

        private Builder(class_4946 model, class_4944 mapping) {
            this.model = model;
            this.mapping = mapping;
        }

        public Builder createFullBlock(class_2248 fullBlock) {
            this.fullBlockLocation = this.model.method_25914().method_25846(fullBlock, this.mapping, WoverBlockModelGenerators.this.vanillaGenerator.field_22831);
            WoverBlockModelGenerators.this.acceptBlockState((class_4917)class_4910.method_25644((class_2248)fullBlock, (class_2960)this.fullBlockLocation));
            return this;
        }

        public Builder createDoor(class_2248 doorBlock) {
            WoverBlockModelGenerators.this.vanillaGenerator.method_25658(doorBlock);
            return this;
        }

        public Builder createCustomFence(class_2248 fenceBlock) {
            class_4944 particles = class_4944.method_46201((class_2248)fenceBlock);
            List<class_2960> locations = Stream.of(class_4943.field_40630, class_4943.field_40631, class_4943.field_40621, class_4943.field_40622, class_4943.field_40623).map(template -> template.method_25846(fenceBlock, particles, WoverBlockModelGenerators.this.vanillaGenerator.field_22831)).toList();
            WoverBlockModelGenerators.this.acceptBlockState(class_4910.method_46189((class_2248)fenceBlock, (class_2960)locations.get(0), (class_2960)locations.get(1), (class_2960)locations.get(2), (class_2960)locations.get(3), (class_2960)locations.get(4)));
            this.createInventoryModel(fenceBlock, class_4943.field_40624, particles);
            return this;
        }

        public Builder createCustomFenceGate(class_2248 gateBlock) {
            class_4944 particles = class_4944.method_46201((class_2248)gateBlock);
            List<class_2960> locations = Stream.of(class_4943.field_40626, class_4943.field_40625, class_4943.field_40628, class_4943.field_40627).map(template -> template.method_25846(gateBlock, particles, WoverBlockModelGenerators.this.vanillaGenerator.field_22831)).toList();
            WoverBlockModelGenerators.this.acceptBlockState(class_4910.method_25626((class_2248)gateBlock, (class_2960)locations.get(0), (class_2960)locations.get(1), (class_2960)locations.get(2), (class_2960)locations.get(3), (boolean)false));
            return this;
        }

        private Builder createFullBlockVariant(class_2248 block) {
            class_4946 texturedModel = WoverBlockModelGenerators.this.getTextureModels(block, class_4946.field_23036.get(block));
            class_2960 resourceLocation = texturedModel.method_25916(block, WoverBlockModelGenerators.this.vanillaGenerator.field_22831);
            WoverBlockModelGenerators.this.acceptBlockState((class_4917)class_4910.method_25644((class_2248)block, (class_2960)resourceLocation));
            return this;
        }

        private void createTrapdoor(class_2248 block, boolean hasOrientation) {
            if (!hasOrientation) {
                WoverBlockModelGenerators.this.vanillaGenerator.method_25671(block);
            } else {
                WoverBlockModelGenerators.this.vanillaGenerator.method_25665(block);
            }
        }

        public Builder createSlab(class_2248 slabBlock) {
            if (this.fullBlockLocation == null) {
                throw new IllegalStateException("Please call createFullBlock before calling createSlab");
            }
            List<class_2960> locations = Stream.of(class_4943.field_22909, class_4943.field_22910).map(template -> this.computeModelIfAbsent((class_4942)template, slabBlock)).toList();
            WoverBlockModelGenerators.this.acceptBlockState(class_4910.method_25668((class_2248)slabBlock, (class_2960)locations.get(0), (class_2960)locations.get(1), (class_2960)this.fullBlockLocation));
            WoverBlockModelGenerators.this.delegateItemModel(slabBlock, locations.get(0));
            return this;
        }

        private class_2960 computeModelIfAbsent(class_4942 modelTemplate, class_2248 block) {
            return this.models.computeIfAbsent(modelTemplate, m -> m.method_25846(block, this.mapping, WoverBlockModelGenerators.this.vanillaGenerator.field_22831));
        }

        private void createInventoryModel(class_2248 wallBlock, class_4942 inventoryModel, class_4944 mapping) {
            WoverBlockModelGenerators.this.delegateItemModel(wallBlock, inventoryModel.method_25846(wallBlock, mapping, WoverBlockModelGenerators.this.vanillaGenerator.field_22831));
        }
    }
}

