/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.block.api;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.betterx.wover.block.api.BlockTagProvider;
import org.betterx.wover.block.api.CustomBlockItemProvider;
import org.betterx.wover.block.impl.WoverBlockItemImpl;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.item.api.ItemRegistry;
import org.betterx.wover.loot.api.BlockLootProvider;
import org.betterx.wover.loot.api.LootLookupProvider;
import org.betterx.wover.loot.api.LootTableManager;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;
import org.jetbrains.annotations.NotNull;

public class BlockRegistry {
    private static final Map<ModCore, BlockRegistry> REGISTRIES = new HashMap<ModCore, BlockRegistry>();
    public final ModCore C;
    private final Map<class_2960, class_2248> blocks = new HashMap<class_2960, class_2248>();
    private Map<class_2248, class_6862<class_2248>[]> datagenTags;
    private final ItemRegistry itemRegistry;

    private BlockRegistry(ModCore modeCore) {
        this.C = modeCore;
        this.itemRegistry = ItemRegistry.forMod((ModCore)modeCore);
        if (ModCore.isDatagen()) {
            this.datagenTags = new HashMap<class_2248, class_6862<class_2248>[]>();
        }
    }

    public static Stream<BlockRegistry> streamAll() {
        return REGISTRIES.values().stream();
    }

    public static BlockRegistry forMod(ModCore modCore) {
        return REGISTRIES.computeIfAbsent(modCore, c -> new BlockRegistry(modCore));
    }

    public Stream<class_2248> allBlocks() {
        return this.blocks.values().stream();
    }

    public Stream<class_1747> allBlockItems() {
        return this.blocks.values().stream().filter(block -> block.method_8389() instanceof class_1747).map(block -> (class_1747)block.method_8389());
    }

    @SafeVarargs
    public final <T extends class_2248> T register(String path, T block, class_6862<class_2248> ... tags) {
        return this.register(path, block, tags, (class_6862<class_1792>[])null);
    }

    public <T extends class_2248> T register(String path, T block, class_6862<class_2248>[] tags, class_6862<class_1792>[] itemTags) {
        if (block != null && block != class_2246.field_10124) {
            class_1747 item;
            class_2960 id;
            class_2960 class_29602 = id = tags == null ? this._registerBlockOnly(path, block, new class_6862[0]) : this._registerBlockOnly(path, block, tags);
            if (block instanceof CustomBlockItemProvider) {
                CustomBlockItemProvider provider = (CustomBlockItemProvider)block;
                item = provider.getCustomBlockItem(id, this.defaultBlockItemSettings());
            } else {
                item = WoverBlockItemImpl.create(block, this.defaultBlockItemSettings());
            }
            if (itemTags == null) {
                this.registerBlockItem(path, item, new class_6862[0]);
            } else {
                this.registerBlockItem(path, item, itemTags);
            }
            if (block.method_9564().method_50011() && ((FlammableBlockRegistry.Entry)FlammableBlockRegistry.getDefaultInstance().get(block)).getBurnChance() == 0) {
                FlammableBlockRegistry.getDefaultInstance().add(block, 5, 5);
            }
        }
        return block;
    }

    @SafeVarargs
    private class_2960 _registerBlockOnly(String path, class_2248 block, class_6862<class_2248> ... tags) {
        class_2960 id = this.C.mk(path);
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)id, (Object)block);
        this.blocks.put(id, block);
        if (this.datagenTags != null && tags != null && tags.length > 0) {
            this.datagenTags.put(block, tags);
        }
        return id;
    }

    @SafeVarargs
    public final <T extends class_2248> T registerBlockOnly(String path, T block, class_6862<class_2248> ... tags) {
        if (block != null && block != class_2246.field_10124) {
            this._registerBlockOnly(path, block, tags);
        }
        return block;
    }

    @SafeVarargs
    private class_1747 registerBlockItem(String path, class_1747 item, class_6862<class_1792> ... tags) {
        return (class_1747)this.itemRegistry.register(path, (class_1792)item, tags);
    }

    protected class_1792.class_1793 defaultBlockItemSettings() {
        return new class_1792.class_1793();
    }

    public void bootstrapBlockTags(TagBootstrapContext<class_2248> ctx) {
        if (this.datagenTags != null) {
            this.datagenTags.forEach((arg_0, arg_1) -> ctx.add(arg_0, arg_1));
        }
        this.blocks.entrySet().stream().filter(b -> b.getValue() instanceof BlockTagProvider).forEach(b -> ((BlockTagProvider)b.getValue()).registerBlockTags((class_2960)b.getKey(), ctx));
    }

    public void bootstrapBlockLoot(@NotNull class_7225.class_7874 lookup, @NotNull BiConsumer<class_5321<class_52>, class_52.class_53> biConsumer) {
        LootLookupProvider provider = new LootLookupProvider(lookup);
        this.blocks.entrySet().stream().filter(b -> b.getValue() instanceof BlockLootProvider).forEach(b -> {
            class_5321<class_52> key = LootTableManager.getBlockLootTableKey(this.C, (class_2960)b.getKey());
            class_52.class_53 builder = ((BlockLootProvider)b.getValue()).registerBlockLoot((class_2960)b.getKey(), provider, key);
            if (builder != null) {
                biConsumer.accept(key, builder);
            }
        });
    }
}

