/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.state.impl;

import com.google.gson.JsonObject;
import de.ambertation.wunderlib.configs.ConfigResource;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_7699;
import org.betterx.wover.config.api.DatapackConfigs;
import org.betterx.wover.events.api.WorldLifecycle;
import org.jetbrains.annotations.ApiStatus;

public class WorldDatapackConfigImpl {
    private static final Map<String, ConfigResource> CONFIGS = new HashMap<String, ConfigResource>();
    final List<LoadedItem> resources = new LinkedList<LoadedItem>();

    public static void registerConfig(ConfigResource config) {
        CONFIGS.put(config.location.method_12832(), config);
    }

    @ApiStatus.Internal
    public static void initialize() {
        WorldLifecycle.BEFORE_LOADING_RESOURCES.subscribe(WorldDatapackConfigImpl::onResourcesLoaded, 100000000);
        WorldLifecycle.RESOURCES_LOADED.subscribe(WorldDatapackConfigImpl::onResourcesLoaded, 100000000);
    }

    private static void onResourcesLoaded(class_3300 resourceManager, class_7699 featureFlagSet) {
        ConfigResource.invalidateCache();
    }

    private static void onResourcesLoaded(class_3300 resourceManager) {
        CONFIGS.values().forEach(v -> v.setRootElement((JsonObject)null));
        List paths = CONFIGS.keySet().stream().toList();
        WorldDatapackConfigImpl obj = new WorldDatapackConfigImpl();
        DatapackConfigs.instance().runForConfigPaths(resourceManager, paths, obj::processBiomeConfigs, obj::whenFinished);
    }

    private void processBiomeConfigs(class_2960 resourceLocation, JsonObject jsonObject) {
        ConfigResource config;
        int priority = 1000;
        boolean defaultPriority = true;
        if (jsonObject.has("priority") && jsonObject.get("priority").isJsonPrimitive() && jsonObject.getAsJsonPrimitive("priority").isNumber()) {
            defaultPriority = false;
            priority = jsonObject.getAsJsonPrimitive("priority").getAsInt();
        }
        if ((config = CONFIGS.get(resourceLocation.method_12832())) != null) {
            this.resources.add(new LoadedItem(resourceLocation, jsonObject, config, priority, defaultPriority));
        }
    }

    private void whenFinished() {
        this.resources.sort((a, b) -> {
            if (a.priority() == b.priority()) {
                return a.resource.method_12833(b.resource);
            }
            return a.priority() > b.priority() ? -1 : 1;
        });
        this.resources.forEach(v -> v.cfg.setRootElement(v.object));
    }

    private record LoadedItem(class_2960 resource, JsonObject object, ConfigResource cfg, int initialPriority, boolean defaultPriority) {
        public boolean isMaster() {
            return this.resource.method_12836().equals(this.cfg.location.method_12836());
        }

        public int priority() {
            if (this.defaultPriority && this.isMaster()) {
                return this.initialPriority * 2;
            }
            return this.initialPriority;
        }

        @Override
        public String toString() {
            return String.valueOf(this.resource) + " -> " + this.priority();
        }
    }
}

