/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.state.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.ambertation.wunderlib.utils.Version;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_32;
import net.minecraft.class_5218;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.core.impl.registry.ModCoreImpl;
import org.betterx.wover.entrypoint.LibWoverEvents;
import org.betterx.wover.events.api.Event;
import org.betterx.wover.events.api.WorldLifecycle;
import org.betterx.wover.events.api.types.OnWorldConfig;
import org.betterx.wover.events.impl.EventImpl;
import org.betterx.wover.legacy.api.LegacyHelper;
import org.betterx.wover.util.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class WorldConfigImpl {
    private static final Map<ModCore, class_2487> TAGS = Maps.newHashMap();
    private static final List<ModCore> MODS = Lists.newArrayList();
    private static final Map<ModCore, EventImpl<OnWorldConfig>> EVENTS = Maps.newHashMap();
    private static final String TAG_CREATED = "create_version";
    private static final String TAG_MODIFIED = "modify_version";
    private static File dataDir;

    @ApiStatus.Internal
    public static void initialize() {
        WorldLifecycle.WORLD_FOLDER_READY.subscribe(WorldConfigImpl::loadForWorld, 100000000);
        WorldConfigImpl.registerMod(ModCoreImpl.GLOBAL_MOD);
        WorldConfigImpl.registerMod(LegacyHelper.BCLIB_CORE);
        WorldConfigImpl.registerMod(LegacyHelper.WORLDS_TOGETHER_CORE);
    }

    private static void loadForWorld(class_32.class_5143 levelStorageAccess) {
        dataDir = levelStorageAccess.method_27010(class_5218.field_24188).resolve("data").toFile();
        ArrayList eventQueue = new ArrayList(MODS.size());
        ((Stream)MODS.stream().parallel()).forEach(modCore -> {
            File file = new File(dataDir, modCore.modId + ".nbt");
            if (file.exists()) {
                try {
                    class_2487 root = class_2507.method_30613((Path)file.toPath(), (class_2505)class_2505.method_53899((long)0x200000L));
                    TAGS.put((ModCore)modCore, root);
                    eventQueue.add(new Pair(modCore, (Object)OnWorldConfig.State.LOADED));
                }
                catch (IOException e) {
                    LibWoverEvents.C.log.error("World data loading failed", (Exception)e);
                    eventQueue.add(new Pair(modCore, (Object)OnWorldConfig.State.LOAD_FAILED));
                }
            } else {
                class_2487 root = WorldConfigImpl.setupNewConfig(modCore, false);
                if (modCore == LegacyHelper.BCLIB_CORE) {
                    root.method_10582("version", "9.9.9");
                }
                eventQueue.add(new Pair(modCore, (Object)OnWorldConfig.State.CREATED));
            }
        });
        eventQueue.forEach(pair -> EVENTS.computeIfPresent((ModCore)pair.first, (key, event) -> {
            event.emit(subscriber -> subscriber.config((ModCore)key, TAGS.get(key), (OnWorldConfig.State)((Object)((Object)((Object)((Object)pair.second))))));
            return event;
        }));
    }

    private static class_2487 setupNewConfig(ModCore modCore, boolean emit) {
        class_2487 root = new class_2487();
        TAGS.put(modCore, root);
        root.method_10582(TAG_CREATED, modCore.getModVersion().toString());
        root.method_10582(TAG_MODIFIED, modCore.getModVersion().toString());
        if (emit) {
            EVENTS.computeIfPresent(modCore, (key, event) -> {
                event.emit(subscriber -> subscriber.config(modCore, root, OnWorldConfig.State.CREATED));
                return event;
            });
        }
        return root;
    }

    public static void registerMod(ModCore modCore) {
        if (!MODS.contains(modCore)) {
            MODS.add(modCore);
        }
    }

    public static Event<OnWorldConfig> event(ModCore modCore) {
        return EVENTS.computeIfAbsent(modCore, key -> new EventImpl("WORLD_CONFIG_READY (" + key.modId + ")"));
    }

    public static class_2487 getRootTag(ModCore modCore) {
        class_2487 root = TAGS.get(modCore);
        if (root == null) {
            root = WorldConfigImpl.setupNewConfig(modCore, true);
        }
        return root;
    }

    public static boolean hasMod(ModCore modCore) {
        return MODS.contains(modCore);
    }

    @NotNull
    public static class_2487 getCompoundTag(ModCore modCore, String path) {
        String[] parts = path.split("\\.");
        class_2487 tag = WorldConfigImpl.getRootTag(modCore);
        for (String part : parts) {
            if (tag.method_10545(part)) {
                tag = tag.method_10562(part);
                continue;
            }
            class_2487 t = new class_2487();
            tag.method_10566(part, (class_2520)t);
            tag = t;
        }
        return tag;
    }

    public static void saveFile(ModCore modCore) {
        if (!WorldConfigImpl.hasMod(modCore)) {
            LibWoverEvents.C.log.error("Mod " + modCore.modId + " is not registered for a worldconfig file");
            return;
        }
        try {
            if (dataDir != null && !dataDir.exists()) {
                dataDir.mkdirs();
            }
            class_2487 tag = WorldConfigImpl.getRootTag(modCore);
            tag.method_10582(TAG_MODIFIED, modCore.getModVersion().toString());
            File tempFile = new File(dataDir, modCore.modId + "_temp.nbt");
            class_2507.method_30614((class_2487)tag, (Path)tempFile.toPath());
            File oldFile = new File(dataDir, modCore.modId + "_old.nbt");
            File dataFile = new File(dataDir, modCore.modId + ".nbt");
            class_156.method_30626((Path)dataFile.toPath(), (Path)tempFile.toPath(), (Path)oldFile.toPath());
        }
        catch (IOException e) {
            LibWoverEvents.C.log.error("World data saving failed", (Exception)e);
        }
    }

    public static Version getModifiedVersion(ModCore modCore) {
        return new Version(WorldConfigImpl.getRootTag(modCore).method_10558(TAG_MODIFIED));
    }

    public static Version getCreatedVersion(ModCore modCore) {
        return new Version(WorldConfigImpl.getRootTag(modCore).method_10558(TAG_CREATED));
    }
}

