/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.mixin.features.render.model.item;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.caffeinemc.mods.sodium.api.texture.SpriteUtil;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.client.model.quad.BakedQuadView;
import net.caffeinemc.mods.sodium.client.render.immediate.model.BakedModelEncoder;
import net.caffeinemc.mods.sodium.client.render.vertex.VertexConsumerUtils;
import net.caffeinemc.mods.sodium.client.util.DirectionUtil;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ItemRenderer.class})
public class ItemRendererMixin {
    @Unique
    private final RandomSource random = new SingleThreadedRandomSource(42L);
    @Shadow
    @Final
    private ItemColors itemColors;

    @WrapOperation(method={"renderModelLists"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/RandomSource;create()Lnet/minecraft/util/RandomSource;")})
    private RandomSource renderModelFastRandom(Operation<RandomSource> original) {
        return this.random;
    }

    @WrapOperation(method={"renderModelLists"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/Direction;values()[Lnet/minecraft/core/Direction;")})
    private Direction[] renderModelFastDirections(Operation<RandomSource> original) {
        return DirectionUtil.ALL_DIRECTIONS;
    }

    @WrapOperation(method={"renderModelLists"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/ItemRenderer;renderQuadList(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Ljava/util/List;Lnet/minecraft/world/item/ItemStack;II)V")})
    private void renderModelFast(ItemRenderer itemRenderer, PoseStack poseStack, VertexConsumer vertexConsumer, List<BakedQuad> quads, ItemStack itemStack, int light, int overlay, Operation<Void> original) {
        VertexBufferWriter writer = VertexConsumerUtils.convertOrLog(vertexConsumer);
        if (writer == null) {
            original.call(new Object[]{itemRenderer, poseStack, vertexConsumer, quads, itemStack, light, overlay});
            return;
        }
        if (!quads.isEmpty()) {
            this.renderBakedItemQuads(poseStack.last(), writer, quads, itemStack, light, overlay);
        }
    }

    @Unique
    private void renderBakedItemQuads(PoseStack.Pose matrices, VertexBufferWriter writer, List<BakedQuad> quads, ItemStack itemStack, int light, int overlay) {
        for (int i = 0; i < quads.size(); ++i) {
            BakedQuad bakedQuad = quads.get(i);
            if (bakedQuad.getVertices().length < 32) continue;
            BakedQuadView quad = (BakedQuadView)bakedQuad;
            int color = -1;
            if (quad.hasColor()) {
                color = ColorARGB.toABGR(this.itemColors.getColor(itemStack, quad.getColorIndex()));
            }
            BakedModelEncoder.writeQuadVertices(writer, matrices, quad, color, light, overlay, BakedModelEncoder.shouldMultiplyAlpha());
            if (quad.getSprite() == null) continue;
            SpriteUtil.INSTANCE.markSpriteActive(quad.getSprite());
        }
    }
}

