/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.structure.impl.pools;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import org.betterx.wover.entrypoint.LibWoverStructure;
import org.betterx.wover.legacy.api.LegacyHelper;
import org.betterx.wover.structure.impl.pools.SingleEndPoolElement;
import org.jetbrains.annotations.ApiStatus;

public class StructurePoolElementTypeManagerImpl {
    public static final StructurePoolElementType<SingleEndPoolElement> END = StructurePoolElementTypeManagerImpl.registerLegacy(LibWoverStructure.C.id("single_end_pool_element"), SingleEndPoolElement.CODEC);

    public static <P extends StructurePoolElement> StructurePoolElementType<P> register(ResourceLocation location, MapCodec<P> codec) {
        return (StructurePoolElementType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_POOL_ELEMENT, (ResourceLocation)location, () -> codec);
    }

    public static <P extends StructurePoolElement> StructurePoolElementType<P> registerLegacy(ResourceLocation location, MapCodec<P> codec) {
        StructurePoolElementType<P> res = StructurePoolElementTypeManagerImpl.register(location, codec);
        if (LegacyHelper.isLegacyEnabled()) {
            StructurePoolElementTypeManagerImpl.register(LegacyHelper.BCLIB_CORE.convertNamespace(location), LegacyHelper.wrap(codec));
        }
        return res;
    }

    @ApiStatus.Internal
    public static void ensureStaticallyLoaded() {
    }
}

