/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.structure.impl.pools;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.pools.LegacySinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.betterx.wover.structure.api.pools.StructurePoolBuilder;
import org.betterx.wover.structure.api.pools.StructurePoolKey;
import org.betterx.wover.structure.api.processors.StructureProcessorKey;
import org.betterx.wover.structure.impl.pools.SingleEndPoolElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructurePoolBuilderImpl
implements StructurePoolBuilder {
    @NotNull
    private final ResourceKey<StructureTemplatePool> key;
    @NotNull
    private final BootstrapContext<StructureTemplatePool> context;
    @Nullable
    private Holder<StructureTemplatePool> terminator;
    @NotNull
    private StructureTemplatePool.Projection projection;
    private List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>> elements = new LinkedList<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>();

    public StructurePoolBuilderImpl(@NotNull ResourceKey<StructureTemplatePool> key, @NotNull BootstrapContext<StructureTemplatePool> context) {
        this.key = key;
        this.context = context;
        this.projection = StructureTemplatePool.Projection.RIGID;
    }

    @Override
    @NotNull
    public Holder<StructureTemplatePool> register() {
        return this.context.register(this.key, (Object)this.build());
    }

    @Override
    @NotNull
    public Holder<StructureTemplatePool> directHolder() {
        return Holder.direct((Object)this.build());
    }

    @Override
    @NotNull
    public StructurePoolBuilder projection(@NotNull StructureTemplatePool.Projection projection) {
        this.projection = projection;
        return this;
    }

    @Override
    @NotNull
    public StructurePoolBuilder.ElementBuilder startSingle(@NotNull ResourceLocation nbtLocation) {
        return new SinglePoolElementImpl(nbtLocation);
    }

    @Override
    @NotNull
    public StructurePoolBuilder.ElementBuilder startSingleEnd(@NotNull ResourceLocation nbtLocation) {
        return new SingleEndPoolElementImpl(this, nbtLocation);
    }

    @Override
    @NotNull
    public StructurePoolBuilder.ElementBuilder startLegacySingle(@NotNull ResourceLocation nbtLocation) {
        return new LegacyPoolElementImpl(this, nbtLocation);
    }

    @Override
    @NotNull
    public StructurePoolBuilder addEmptyElement(int weight) {
        return this.add(StructurePoolElement.empty(), weight);
    }

    @Override
    @NotNull
    public StructurePoolBuilder add(@NotNull Function<StructureTemplatePool.Projection, ? extends StructurePoolElement> element, int weight) {
        return this.add((Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>)Pair.of(element, (Object)weight));
    }

    @Override
    @NotNull
    public StructurePoolBuilder addFeature(@NotNull ResourceKey<PlacedFeature> feature, int weight) {
        return this.add((Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>)Pair.of((Object)StructurePoolElement.feature((Holder)((Holder)this.context.lookup(Registries.PLACED_FEATURE).get(feature).orElseThrow())), (Object)weight));
    }

    @Override
    @NotNull
    public StructurePoolBuilder addFeature(@NotNull Holder<PlacedFeature> feature, int weight) {
        return this.add((Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>)Pair.of((Object)StructurePoolElement.feature(feature), (Object)weight));
    }

    @NotNull
    private StructurePoolBuilder add(@NotNull Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer> element) {
        this.elements.add(element);
        return this;
    }

    @Override
    @NotNull
    public StructurePoolBuilder terminator(@NotNull Holder<StructureTemplatePool> terminator) {
        this.terminator = terminator;
        return this;
    }

    @Override
    @NotNull
    public StructurePoolBuilder terminator(@NotNull ResourceKey<StructureTemplatePool> terminator) {
        this.terminator = this.context.lookup(Registries.TEMPLATE_POOL).getOrThrow(terminator);
        return this;
    }

    @Override
    @NotNull
    public StructurePoolBuilder terminator(@NotNull StructurePoolKey terminator) {
        return this.terminator(terminator.key);
    }

    @Override
    @NotNull
    public StructurePoolBuilder emptyTerminator() {
        return this.terminator((ResourceKey<StructureTemplatePool>)Pools.EMPTY);
    }

    private StructureTemplatePool build() {
        if (this.terminator == null) {
            this.emptyTerminator();
        }
        return new StructureTemplatePool(this.terminator, (List)ImmutableList.copyOf(this.elements), this.projection);
    }

    public class SinglePoolElementImpl
    implements StructurePoolBuilder.ElementBuilder {
        protected final ResourceLocation nbtLocation;
        protected Holder<StructureProcessorList> processor;
        private int weight;
        protected LiquidSettings liquidSettings;

        SinglePoolElementImpl(ResourceLocation nbtLocation) {
            this.nbtLocation = nbtLocation;
            this.weight = 1;
            this.liquidSettings = null;
        }

        @Override
        @NotNull
        public StructurePoolBuilder.ElementBuilder processor(@NotNull Holder<StructureProcessorList> processor) {
            this.processor = processor;
            return this;
        }

        @Override
        @NotNull
        public StructurePoolBuilder.ElementBuilder processor(@NotNull ResourceKey<StructureProcessorList> processor) {
            this.processor = StructurePoolBuilderImpl.this.context.lookup(Registries.PROCESSOR_LIST).getOrThrow(processor);
            return this;
        }

        @Override
        @NotNull
        public StructurePoolBuilder.ElementBuilder processor(@NotNull StructureProcessorKey processor) {
            return this.processor(processor.key);
        }

        @Override
        @NotNull
        public StructurePoolBuilder.ElementBuilder emptyProcessor() {
            return this.processor((ResourceKey<StructureProcessorList>)ProcessorLists.EMPTY);
        }

        @Override
        @NotNull
        public StructurePoolBuilder.ElementBuilder weight(int weight) {
            this.weight = weight;
            return this;
        }

        @Override
        @NotNull
        public StructurePoolBuilder.ElementBuilder liquidSettingsOverride(LiquidSettings value) {
            this.liquidSettings = value;
            return this;
        }

        @Override
        @NotNull
        public StructurePoolBuilder endElement() {
            if (this.nbtLocation == null) {
                throw new IllegalStateException("Location for a pool entry must be set before pushing it to the pool.");
            }
            if (this.processor == null) {
                this.emptyProcessor();
            }
            return StructurePoolBuilderImpl.this.add((Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>)Pair.of(this.create(), (Object)this.weight));
        }

        protected Function<StructureTemplatePool.Projection, ? extends StructurePoolElement> create() {
            return projection -> new SinglePoolElement(Either.left((Object)this.nbtLocation), this.processor, projection, this.liquidSettings == null ? Optional.empty() : Optional.of(this.liquidSettings));
        }
    }

    public class SingleEndPoolElementImpl
    extends SinglePoolElementImpl {
        SingleEndPoolElementImpl(StructurePoolBuilderImpl this$0, ResourceLocation nbtLocation) {
            super(nbtLocation);
        }

        @Override
        protected Function<StructureTemplatePool.Projection, ? extends StructurePoolElement> create() {
            return projection -> new SingleEndPoolElement((Either<ResourceLocation, StructureTemplate>)Either.left((Object)this.nbtLocation), (Holder<StructureProcessorList>)this.processor, (StructureTemplatePool.Projection)projection);
        }
    }

    public class LegacyPoolElementImpl
    extends SinglePoolElementImpl {
        LegacyPoolElementImpl(StructurePoolBuilderImpl this$0, ResourceLocation nbtLocation) {
            super(nbtLocation);
        }

        @Override
        protected Function<StructureTemplatePool.Projection, ? extends StructurePoolElement> create() {
            return projection -> new LegacySinglePoolElement(Either.left((Object)this.nbtLocation), this.processor, projection, this.liquidSettings == null ? Optional.empty() : Optional.of(this.liquidSettings));
        }
    }
}

