/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.structure.impl.builders;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import org.betterx.wover.structure.api.StructureKey;
import org.betterx.wover.structure.api.builders.BaseStructureBuilder;
import org.jetbrains.annotations.NotNull;

public abstract class BaseStructureBuilderImpl<S extends Structure, R extends BaseStructureBuilder<S, R>, K extends StructureKey<S, R, K>>
implements BaseStructureBuilder<S, R> {
    protected final K key;
    protected final BootstrapContext<Structure> context;
    @NotNull
    protected TerrainAdjustment terrainAdjustment;
    @NotNull
    protected final Map<MobCategory, StructureSpawnOverride> spawnOverrides = new HashMap<MobCategory, StructureSpawnOverride>();

    public BaseStructureBuilderImpl(K key, BootstrapContext<Structure> context) {
        this.key = key;
        this.context = context;
        this.terrainAdjustment = TerrainAdjustment.NONE;
    }

    @Override
    public R adjustment(TerrainAdjustment adjustment) {
        this.terrainAdjustment = adjustment;
        return (R)this;
    }

    @Override
    public Holder<Structure> register() {
        return this.context.register(this.key.key(), (Object)this.build());
    }

    @Override
    public Holder<Structure> directHolder() {
        return Holder.direct((Object)this.build());
    }

    protected abstract Structure build();

    protected Structure.StructureSettings buildSettings() {
        return new Structure.StructureSettings((HolderSet)this.context.lookup(Registries.BIOME).getOrThrow(this.key.biomeTag()), this.spawnOverrides, this.key.step(), this.terrainAdjustment);
    }
}

