/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.structure.impl;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import org.betterx.wover.core.api.registry.DatapackRegistryBuilder;
import org.betterx.wover.entrypoint.LibWoverStructure;
import org.betterx.wover.events.api.types.OnBootstrapRegistry;
import org.betterx.wover.events.impl.EventImpl;
import org.betterx.wover.legacy.api.LegacyHelper;
import org.betterx.wover.structure.api.StructureTypeKey;
import org.betterx.wover.structure.api.structures.nbt.RandomNbtStructure;
import org.betterx.wover.structure.api.structures.nbt.RandomNbtStructurePiece;
import org.betterx.wover.structure.impl.StructureTypeKeyImpl;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureManagerImpl {
    public static final EventImpl<OnBootstrapRegistry<Structure>> BOOTSTRAP_STRUCTURES = new EventImpl("BOOTSTRAP_STRUCTURES");
    public static final StructureType<RandomNbtStructure> RANDOM_NBT_STRUCTURE_TYPE = StructureManagerImpl.registerType(LibWoverStructure.C.id("random_nbt_structure"), RandomNbtStructure.simpleRandomCodec(RandomNbtStructure::new));
    public static final StructurePieceType RANDOM_NBT_STRUCTURE_PIECE = StructureManagerImpl.registerPiece(LibWoverStructure.C.id("random_nbt_structure_piece"), RandomNbtStructurePiece::new);
    private static boolean didInit = false;

    @Nullable
    public static Holder<Structure> getHolder(@Nullable HolderGetter<Structure> getter, @NotNull ResourceKey<Structure> key) {
        if (getter == null) {
            return null;
        }
        Optional h = getter.get(key);
        return h.orElse(null);
    }

    @Nullable
    public static Holder<Structure> getHolder(@Nullable HolderLookup.Provider lookup, @NotNull ResourceKey<Structure> key) {
        if (lookup == null) {
            return null;
        }
        return lookup.lookup(Registries.STRUCTURE).flatMap(r -> r.get(key)).orElse(null);
    }

    @ApiStatus.Internal
    public static void initialize() {
        if (didInit) {
            return;
        }
        didInit = true;
        DatapackRegistryBuilder.addBootstrap((ResourceKey)Registries.STRUCTURE, StructureManagerImpl::onBootstrap);
    }

    public static boolean isValidBiome(Structure.GenerationContext context) {
        return StructureManagerImpl.isValidBiome(context, 5);
    }

    public static boolean isValidBiome(Structure.GenerationContext context, int yPos) {
        BlockPos blockPos = context.chunkPos().getMiddleBlockPosition(yPos);
        return context.validBiome().test(context.chunkGenerator().getBiomeSource().getNoiseBiome(QuartPos.fromBlock((int)blockPos.getX()), QuartPos.fromBlock((int)blockPos.getY()), QuartPos.fromBlock((int)blockPos.getZ()), context.randomState().sampler()));
    }

    private static void onBootstrap(BootstrapContext<Structure> context) {
        BOOTSTRAP_STRUCTURES.emit(c -> c.bootstrap(context));
    }

    @NotNull
    public static <S extends Structure> StructureTypeKey<S> registerType(@NotNull ResourceLocation location, @NotNull StructureTypeKey.StructureFactory<S> structureFactory, @NotNull MapCodec<S> codec) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.STRUCTURE_TYPE, (ResourceLocation)location);
        StructureType type = (StructureType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_TYPE, (ResourceKey)key, () -> codec);
        return new StructureTypeKeyImpl<S>(key, type, structureFactory);
    }

    @NotNull
    public static <S extends Structure> StructureType<S> registerType(@NotNull ResourceLocation location, @NotNull MapCodec<S> codec) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.STRUCTURE_TYPE, (ResourceLocation)location);
        StructureType type = (StructureType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_TYPE, (ResourceKey)key, () -> codec);
        return type;
    }

    @NotNull
    public static StructurePieceType registerPiece(@NotNull ResourceLocation location, @NotNull StructurePieceType pieceType) {
        return (StructurePieceType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_PIECE, (ResourceLocation)location, (Object)pieceType);
    }

    static {
        if (LegacyHelper.isLegacyEnabled()) {
            StructureManagerImpl.registerPiece(LegacyHelper.BCLIB_CORE.id("template_piece"), RandomNbtStructurePiece::new);
        }
    }
}

