/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.structure.api.structures.nbt;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function4;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.apache.commons.lang3.time.StopWatch;
import org.betterx.wover.entrypoint.LibWoverStructure;
import org.betterx.wover.structure.api.StructureNBT;
import org.betterx.wover.structure.api.structures.StructurePlacement;
import org.betterx.wover.structure.api.structures.nbt.RandomNbtStructureElement;
import org.betterx.wover.structure.api.structures.nbt.RandomNbtStructurePiece;
import org.betterx.wover.structure.impl.StructureManagerImpl;
import org.betterx.wover.util.RandomizedWeightedList;
import org.jetbrains.annotations.NotNull;

public class RandomNbtStructure
extends Structure {
    @NotNull
    private final RandomizedWeightedList<RandomNbtStructureElement> elements;
    private final StructurePlacement placement;
    private final boolean keepAir;

    public static <T extends RandomNbtStructure> MapCodec<T> simpleRandomCodec(Function4<Structure.StructureSettings, StructurePlacement, Boolean, RandomizedWeightedList<RandomNbtStructureElement>, T> instancer) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Structure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)StructurePlacement.CODEC.fieldOf("placement").forGetter(RandomNbtStructure::placement), (App)Codec.BOOL.optionalFieldOf("keep_air", (Object)false).forGetter(RandomNbtStructure::keepAir), (App)RandomizedWeightedList.buildCodec(RandomNbtStructureElement.CODEC).fieldOf("configs").forGetter(RandomNbtStructure::elements)).apply((Applicative)instance, instancer));
    }

    public RandomNbtStructure(Structure.StructureSettings structureSettings, StructurePlacement placement, boolean keepAir, @NotNull RandomizedWeightedList<RandomNbtStructureElement> elements) {
        super(structureSettings);
        this.elements = elements;
        this.keepAir = keepAir;
        this.placement = placement;
    }

    public RandomizedWeightedList<RandomNbtStructureElement> elements() {
        return this.elements;
    }

    public StructurePlacement placement() {
        return this.placement;
    }

    public boolean keepAir() {
        return this.keepAir;
    }

    @NotNull
    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext ctx) {
        RandomNbtStructureElement element;
        Mirror mirror;
        StopWatch sw = StopWatch.createStarted();
        Rotation rotation = StructureNBT.getRandomRotation((RandomSource)ctx.random());
        Optional<Structure.GenerationStub> result = this.placement.placementFunction.find(ctx, rotation, mirror = StructureNBT.getRandomMirror((RandomSource)ctx.random()), element = (RandomNbtStructureElement)this.elements.getRandomValue((RandomSource)ctx.random()), (pos, structurePiecesBuilder) -> {
            LibWoverStructure.C.log.debug("Generating RandomNbtStructure: " + String.valueOf(pos) + " (" + sw.getTime() + "ms)");
            this.generatePieces((StructurePiecesBuilder)structurePiecesBuilder, ctx, (BlockPos)pos, rotation, mirror, element);
        });
        if (result.isEmpty()) {
            LibWoverStructure.C.log.debug("Rejected RandomNbtStructure " + String.valueOf(element.nbtLocation()) + " in " + sw.getTime() + "ms");
        } else {
            LibWoverStructure.C.log.debug("Accepted RandomNbtStructure " + String.valueOf(element.nbtLocation()) + " in " + sw.getTime() + "ms");
        }
        return result;
    }

    private void generatePieces(StructurePiecesBuilder structurePiecesBuilder, Structure.GenerationContext ctx, BlockPos pos, Rotation rotation, Mirror mirror, RandomNbtStructureElement element) {
        StructureTemplate template = ctx.structureTemplateManager().getOrCreate(element.nbtLocation());
        BlockPos center = StructurePlacement.getCenter(mirror, template);
        structurePiecesBuilder.addPiece((StructurePiece)new RandomNbtStructurePiece(ctx.structureTemplateManager(), element.nbtLocation(), RandomNbtStructurePiece.settings(rotation, mirror, center, this.keepAir), pos.above(element.yOffset()), this.keepAir));
    }

    @NotNull
    public StructureType<?> type() {
        return StructureManagerImpl.RANDOM_NBT_STRUCTURE_TYPE;
    }
}

