/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.structure.api.sets;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import org.betterx.wover.events.api.Event;
import org.betterx.wover.events.api.types.OnBootstrapRegistry;
import org.betterx.wover.structure.api.StructureKey;
import org.betterx.wover.structure.api.builders.BaseStructureBuilder;
import org.betterx.wover.structure.api.sets.StructureSetBuilder;
import org.betterx.wover.structure.api.sets.StructureSetKey;
import org.betterx.wover.structure.impl.sets.StructureSetManagerImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureSetManager {
    public static final Event<OnBootstrapRegistry<StructureSet>> BOOTSTRAP_STRUCTURE_SETS = StructureSetManagerImpl.BOOTSTRAP_STRUCTURE_SETS;

    private StructureSetManager() {
    }

    public static StructureSetKey createKey(ResourceLocation location) {
        return new StructureSetKey(location);
    }

    public static StructureSetKey createKey(StructureKey<?, ?, ?> structure) {
        return StructureSetManager.createKey(structure.key().location());
    }

    public static <S extends Structure, T extends BaseStructureBuilder<S, T>, R extends StructureKey<S, T, R>> StructureSetBuilder bootstrap(R structure, BootstrapContext<StructureSet> context) {
        return StructureSetManager.createKey(structure).bootstrap(context).addStructure(structure);
    }

    @Nullable
    public static Holder<StructureSet> getHolder(@Nullable HolderGetter<StructureSet> getter, @NotNull ResourceKey<StructureSet> key) {
        return StructureSetManagerImpl.getHolder(getter, key);
    }

    @Nullable
    public static Holder<StructureSet> getHolder(@Nullable BootstrapContext<?> context, @NotNull ResourceKey<StructureSet> key) {
        return StructureSetManagerImpl.getHolder((HolderGetter<StructureSet>)context.lookup(Registries.STRUCTURE_SET), key);
    }
}

