/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.world.structures;

import com.google.common.collect.ImmutableList;
import com.kyanite.deeperdarker.DeeperDarker;
import com.kyanite.deeperdarker.world.structures.DDProcessorLists;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class DDPools {
    public static final ResourceKey<StructureTemplatePool> TEMPLE_START = DDPools.createKey("ancient_temple/basement");

    public static void bootstrap(BootstrapContext<StructureTemplatePool> context) {
        Holder.Reference empty = context.lookup(Registries.TEMPLATE_POOL).getOrThrow(Pools.EMPTY);
        Holder.Reference degradation = context.lookup(Registries.PROCESSOR_LIST).getOrThrow(DDProcessorLists.ANCIENT_TEMPLE_DEGRADATION);
        context.register(TEMPLE_START, (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of(DDPools.location("ancient_temple/basement/center_0", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/center_1", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/center_2", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/center_3", (Holder<StructureProcessorList>)degradation), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(DDPools.createKey("ancient_temple/basement/aisles"), (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of(DDPools.location("ancient_temple/basement/aisles/secret_aisle", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/aisles/aisle_0", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/aisles/aisle_1", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/aisles/aisle_2", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/aisles/aisle_3", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/aisles/aisle_4", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/aisles/aisle_5", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/aisles/aisle_6", (Holder<StructureProcessorList>)degradation), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(DDPools.createKey("ancient_temple/basement/corners"), (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of(DDPools.location("ancient_temple/basement/corners/corner_0", (Holder<StructureProcessorList>)degradation), (Object)3), (Object)Pair.of(DDPools.location("ancient_temple/basement/corners/corner_1", (Holder<StructureProcessorList>)degradation), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(DDPools.createKey("ancient_temple/basement/rooms"), (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of(DDPools.location("ancient_temple/basement/rooms/portal_0", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/rooms/portal_1", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/rooms/throne", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/rooms/room_0", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/rooms/room_1", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/rooms/room_2", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/rooms/room_3", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/rooms/room_4", (Holder<StructureProcessorList>)degradation), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(DDPools.createKey("ancient_temple/basement/stairs"), (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of(DDPools.location("ancient_temple/basement/stairs/staircase_0", (Holder<StructureProcessorList>)degradation), (Object)2), (Object)Pair.of(DDPools.location("ancient_temple/basement/stairs/staircase_1", (Holder<StructureProcessorList>)degradation), (Object)2), (Object)Pair.of(DDPools.location("ancient_temple/basement/stairs/staircase_2", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/stairs/staircase_3", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/stairs/staircase_4", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/stairs/staircase_5", (Holder<StructureProcessorList>)degradation), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(DDPools.createKey("ancient_temple/upper"), (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of(DDPools.location("ancient_temple/upper/fountain_0", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/upper/fountain_1", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/upper/fountain_2", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/upper/apex_0", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/upper/apex_1", (Holder<StructureProcessorList>)degradation), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(DDPools.createKey("ancient_temple/upper/corners"), (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of(DDPools.location("ancient_temple/upper/corners/corner_0", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/upper/corners/corner_1", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/upper/corners/corner_2", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/upper/corners/corner_3", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/upper/corners/corner_4", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/upper/corners/corner_5", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/upper/corners/corner_6", (Holder<StructureProcessorList>)degradation), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(DDPools.createKey("ancient_temple/upper/rooms"), (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of(DDPools.location("ancient_temple/upper/rooms/room_0", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/upper/rooms/room_1", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/upper/rooms/room_2", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/upper/rooms/room_3", (Holder<StructureProcessorList>)degradation), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(DDPools.createKey("ancient_temple/mobs"), (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of(DDPools.location("ancient_temple/mobs/shattered", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/mobs/snapper", (Holder<StructureProcessorList>)degradation), (Object)1)), StructureTemplatePool.Projection.RIGID));
    }

    public static Function<StructureTemplatePool.Projection, SinglePoolElement> location(String name, Holder<StructureProcessorList> processor) {
        return projection -> new SinglePoolElement(Either.left((Object)DeeperDarker.rl(name)), (Holder)processor, (StructureTemplatePool.Projection)projection, Optional.empty()){};
    }

    public static ResourceKey<StructureTemplatePool> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)DeeperDarker.rl(name));
    }
}

