/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.content.entities;

import com.kyanite.deeperdarker.content.DDEntities;
import com.kyanite.deeperdarker.content.DDSounds;
import com.kyanite.deeperdarker.content.entities.goals.DisturbanceGoal;
import com.kyanite.deeperdarker.content.entities.goals.DisturbanceListener;
import com.kyanite.deeperdarker.util.DDDamageTypes;
import com.kyanite.deeperdarker.util.DDTags;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.Nullable;

public class Stalker
extends Monster
implements DisturbanceListener,
VibrationSystem {
    public final AnimationState idleState = new AnimationState();
    public final AnimationState attackState = new AnimationState();
    public final AnimationState ringAttackState = new AnimationState();
    public final AnimationState emergeState = new AnimationState();
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS).setDarkenScreen(true);
    private final DynamicGameEventListener<VibrationSystem.Listener> dynamicGameEventListener = new DynamicGameEventListener((GameEventListener)new VibrationSystem.Listener((VibrationSystem)this));
    private final VibrationSystem.User vibrationUser = new VibrationUser();
    private final VibrationSystem.Data vibrationData = new VibrationSystem.Data();
    public BlockPos disturbanceLocation;
    private int emergingTime;
    private int rangedCooldown = 440;

    public Stalker(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.setPathfindingMalus(PathType.LAVA, 8.0f);
        this.setPathfindingMalus(PathType.POWDER_SNOW, 8.0f);
        this.setPathfindingMalus(PathType.UNPASSABLE_RAIL, 0.0f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true));
        this.goalSelector.addGoal(2, (Goal)new DisturbanceGoal((PathfinderMob)this, 1.1));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.9));
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.4));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 200.0).add(Attributes.ATTACK_DAMAGE, 22.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ARMOR, 4.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).build();
    }

    public void setCustomName(Component name) {
        super.setCustomName(name);
        this.bossEvent.setName(this.getDisplayName());
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)DDSounds.STALKER_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)DDSounds.STALKER_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)DDSounds.STALKER_HURT.get();
    }

    public boolean doHurtTarget(Entity entity) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        return super.doHurtTarget(entity);
    }

    public void tick() {
        List players;
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            VibrationSystem.Ticker.tick((Level)level2, (VibrationSystem.Data)this.vibrationData, (VibrationSystem.User)this.vibrationUser);
        }
        super.tick();
        if (this.getPose() == Pose.EMERGING) {
            if (++this.emergingTime > 70) {
                this.setPose(Pose.STANDING);
            }
            this.setTarget(null);
        }
        if (!(players = this.level().getNearbyPlayers(TargetingConditions.forCombat().range(10.0), (LivingEntity)this, this.getBoundingBox().inflate(10.0, 8.0, 10.0))).isEmpty()) {
            --this.rangedCooldown;
            if (this.rangedCooldown < -200) {
                if (this.level().isClientSide()) {
                    this.ringAttackState.stop();
                }
                this.rangedCooldown = 440;
            } else if (this.rangedCooldown < 0 && !this.level().isClientSide()) {
                Player player2;
                for (Player player2 : players) {
                    player2.hurt(DDDamageTypes.source(this.level(), DDDamageTypes.RING, (Entity)player2, (Entity)this), 2.0f);
                }
                if (this.rangedCooldown % 40 == 0 && (player2 = this.level()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)player2;
                    int spawn = this.random.nextIntBetweenInclusive(1, 3);
                    for (int i = 0; i < spawn; ++i) {
                        BlockPos spawnPos = new BlockPos((int)this.getRandomX(5.0), (int)this.getRandomY(), (int)this.getRandomZ(5.0));
                        ((EntityType)DDEntities.SCULK_LEECH.get()).spawn(serverLevel, spawnPos, MobSpawnType.EVENT);
                    }
                }
            }
        } else if (this.rangedCooldown < 0) {
            --this.rangedCooldown;
        }
        if (this.level().isClientSide()) {
            if (!(this.idleState.isStarted() || this.attackState.isStarted() || this.ringAttackState.isStarted())) {
                this.idleState.start(this.tickCount);
            }
            if (this.rangedCooldown == 0) {
                this.idleState.stop();
                this.attackState.stop();
                this.ringAttackState.start(this.tickCount);
            }
            if (this.getPose() == Pose.EMERGING) {
                double sX = this.random.nextGaussian() * 0.02;
                double sY = this.random.nextGaussian() * 0.02;
                double sZ = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, this.getBlockStateOn()), this.getRandomX(1.0), this.getY(), this.getRandomZ(1.0), sX, sY, sZ);
            }
        }
    }

    public void aiStep() {
        super.aiStep();
        this.bossEvent.setProgress(this.getHealth() / this.getMaxHealth());
    }

    public void handleEntityEvent(byte id) {
        if (id == 4) {
            this.idleState.stop();
            this.attackState.start(this.tickCount);
        } else {
            super.handleEntityEvent(id);
        }
    }

    public boolean isWithinMeleeAttackRange(LivingEntity entity) {
        return this.getAttackBoundingBox().inflate(2.8, 1.0, 2.8).intersects(entity.getBoundingBox());
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (key.equals((Object)DATA_POSE)) {
            if (this.getPose() == Pose.EMERGING) {
                this.emergeState.start(this.tickCount);
            }
            if (this.getPose() == Pose.STANDING) {
                this.emergeState.stop();
            }
        }
        super.onSyncedDataUpdated(key);
    }

    public void startSeenByPlayer(ServerPlayer serverPlayer) {
        super.startSeenByPlayer(serverPlayer);
        this.bossEvent.addPlayer(serverPlayer);
    }

    public void stopSeenByPlayer(ServerPlayer serverPlayer) {
        super.stopSeenByPlayer(serverPlayer);
        this.bossEvent.removePlayer(serverPlayer);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, SpawnGroupData spawnGroupData) {
        if (spawnType == MobSpawnType.TRIGGERED) {
            this.setPose(Pose.EMERGING);
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public void updateDynamicGameEventListener(BiConsumer<DynamicGameEventListener<?>, ServerLevel> listenerConsumer) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            listenerConsumer.accept(this.dynamicGameEventListener, level2);
        }
    }

    public boolean canTargetEntity(Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)target;
            return this.level() == target.level() && EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(target) && !this.isAlliedTo(target) && entity.getType() != EntityType.ARMOR_STAND && !entity.getType().is(DDTags.Misc.SCULK) && !entity.isInvulnerable() && !entity.isDeadOrDying() && this.level().getWorldBorder().isWithinBounds(entity.getBoundingBox());
        }
        return false;
    }

    @Override
    public BlockPos getDisturbanceLocation() {
        return this.disturbanceLocation;
    }

    @Override
    public void setDisturbanceLocation(BlockPos disturbancePos) {
        this.disturbanceLocation = disturbancePos;
    }

    public VibrationSystem.Data getVibrationData() {
        return this.vibrationData;
    }

    public VibrationSystem.User getVibrationUser() {
        return this.vibrationUser;
    }

    class VibrationUser
    implements VibrationSystem.User {
        private final PositionSource positionSource;

        VibrationUser() {
            this.positionSource = new EntityPositionSource((Entity)Stalker.this, Stalker.this.getEyeHeight());
        }

        public int getListenerRadius() {
            return 20;
        }

        public PositionSource getPositionSource() {
            return this.positionSource;
        }

        public TagKey<GameEvent> getListenableEvents() {
            return GameEventTags.WARDEN_CAN_LISTEN;
        }

        public boolean canTriggerAvoidVibration() {
            return true;
        }

        public boolean canReceiveVibration(ServerLevel level, BlockPos pPos, Holder<GameEvent> gameEvent, GameEvent.Context context) {
            if (!Stalker.this.isNoAi() && !Stalker.this.isDeadOrDying() && !Stalker.this.getBrain().hasMemoryValue(MemoryModuleType.VIBRATION_COOLDOWN) && level.getWorldBorder().isWithinBounds(pPos)) {
                Entity entity = context.sourceEntity();
                if (entity instanceof LivingEntity) {
                    LivingEntity target = (LivingEntity)entity;
                    return Stalker.this.canTargetEntity((Entity)target);
                }
                return true;
            }
            return false;
        }

        public void onReceiveVibration(ServerLevel level, BlockPos pPos, Holder<GameEvent> gameEvent, @Nullable Entity entity, @Nullable Entity playerEntity, float distance) {
            if (Stalker.this.isDeadOrDying()) {
                return;
            }
            Stalker.this.playSound((SoundEvent)DDSounds.STALKER_NOTICE.get(), 2.0f, 1.0f);
            if (entity != null && Stalker.this.canTargetEntity(entity)) {
                LivingEntity target;
                if (entity instanceof LivingEntity && !(target = (LivingEntity)entity).getType().is(DDTags.Misc.SCULK)) {
                    Stalker.this.setTarget(target);
                }
                return;
            }
            if (Stalker.this.getTarget() != null) {
                Stalker.this.setTarget(null);
            }
            Stalker.this.disturbanceLocation = pPos;
        }
    }
}

