/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.content.blocks.vegetation;

import com.kyanite.deeperdarker.content.DDBlocks;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class IceLilyBlock
extends BushBlock {
    public static final MapCodec<IceLilyBlock> CODEC = IceLilyBlock.simpleCodec(IceLilyBlock::new);
    public static final BooleanProperty HAS_FLOWER = BooleanProperty.create((String)"has_flower");
    private static final VoxelShape LILY_PAD = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.5, (double)15.0);
    private static final VoxelShape FLOWER = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0);

    public IceLilyBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HAS_FLOWER, (Comparable)Boolean.valueOf(true)));
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(Items.SHEARS) && ((Boolean)state.getValue((Property)HAS_FLOWER)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)HAS_FLOWER, (Comparable)Boolean.valueOf(false)), 3);
            level.playSound(player, pos, SoundEvents.BIG_DRIPLEAF_BREAK, SoundSource.BLOCKS);
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack(DDBlocks.LILY_FLOWER));
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        ItemStack stack = context.getItemInHand();
        if (!stack.has(DataComponents.ENTITY_DATA)) {
            return super.getStateForPlacement(context);
        }
        return (BlockState)super.getStateForPlacement(context).setValue((Property)HAS_FLOWER, (Comparable)Boolean.valueOf(false));
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        FluidState fluidState = level.getFluidState(pos);
        FluidState fluidStateAbove = level.getFluidState(pos.above());
        return (fluidState.getType() == Fluids.WATER || state.getBlock() instanceof IceBlock) && fluidStateAbove.getType() == Fluids.EMPTY;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity pEntity) {
        super.entityInside(state, level, pos, pEntity);
        if (level instanceof ServerLevel && pEntity instanceof Boat) {
            level.destroyBlock(new BlockPos((Vec3i)pos), true, pEntity);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return this.mayPlaceOn(level.getBlockState(pos.below()), (BlockGetter)level, pos.below());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HAS_FLOWER});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)HAS_FLOWER) != false ? Shapes.or((VoxelShape)LILY_PAD, (VoxelShape)FLOWER) : LILY_PAD;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return LILY_PAD;
    }
}

