/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.client.model;

import com.kyanite.deeperdarker.content.entities.SculkCentipede;
import com.kyanite.deeperdarker.content.entities.animations.SculkCentipedeAnimation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class SculkCentipedeModel
extends HierarchicalModel<SculkCentipede> {
    private final ModelPart root;
    private final ModelPart head;

    public SculkCentipedeModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("root").getChild("centipede").getChild("body").getChild("body_1").getChild("body_2").getChild("body_3");
    }

    public static LayerDefinition createBodyModel() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.getRoot();
        PartDefinition root = parts.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition centipede = root.addOrReplaceChild("centipede", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-1.5f, (float)-15.0f));
        PartDefinition body = centipede.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)18.0f));
        PartDefinition body1 = body.addOrReplaceChild("body_1", CubeListBuilder.create().texOffs(0, 27).addBox(-3.0f, -1.5f, -6.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body1.addOrReplaceChild("left_feet_1", CubeListBuilder.create().texOffs(12, 27).addBox(-0.25f, 0.0f, -3.0f, 4.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)1.4f, (float)-3.0f));
        body1.addOrReplaceChild("right_feet_1", CubeListBuilder.create().texOffs(12, 27).mirror().addBox(-3.75f, 0.0f, -3.0f, 4.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-3.0f, (float)1.4f, (float)-3.0f));
        PartDefinition body2 = body1.addOrReplaceChild("body_2", CubeListBuilder.create().texOffs(0, 18).addBox(-3.0f, -1.5f, -6.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-6.0f));
        body2.addOrReplaceChild("left_feet_2", CubeListBuilder.create().texOffs(12, 18).addBox(-0.25f, 0.0f, -3.0f, 4.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)1.4f, (float)-3.0f));
        body2.addOrReplaceChild("right_feet_2", CubeListBuilder.create().texOffs(12, 18).mirror().addBox(-3.75f, 0.0f, -3.0f, 4.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-3.0f, (float)1.4f, (float)-3.0f));
        PartDefinition body3 = body2.addOrReplaceChild("body_3", CubeListBuilder.create().texOffs(0, 9).addBox(-3.0f, -1.5f, -6.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-6.0f));
        body3.addOrReplaceChild("left_feet_3", CubeListBuilder.create().texOffs(12, 9).addBox(-0.25f, 0.0f, -3.0f, 4.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)1.4f, (float)-3.0f));
        body3.addOrReplaceChild("right_feet_3", CubeListBuilder.create().texOffs(12, 9).mirror().addBox(-3.75f, 0.0f, -3.0f, 4.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-3.0f, (float)1.4f, (float)-3.0f));
        PartDefinition head = body3.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -1.5f, -6.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-6.0f));
        PartDefinition frontJaw = head.addOrReplaceChild("front_jaw", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.0f, (float)-6.0f));
        frontJaw.addOrReplaceChild("front_left_jaw", CubeListBuilder.create().texOffs(13, 1).addBox(-1.5f, 0.0f, -5.0f, 3.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)0.0f, (float)0.0f));
        frontJaw.addOrReplaceChild("front_right_jaw", CubeListBuilder.create().texOffs(13, 1).mirror().addBox(-1.5f, 0.0f, -5.0f, 3.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-2.5f, (float)0.0f, (float)0.0f));
        PartDefinition tendrils = head.addOrReplaceChild("tendrils", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-1.5f, (float)-4.5f));
        tendrils.addOrReplaceChild("left_tendril", CubeListBuilder.create().texOffs(24, 24).addBox(0.0f, -3.0f, -7.5f, 0.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.75f, (float)0.0f, (float)0.0f));
        tendrils.addOrReplaceChild("right_tendril", CubeListBuilder.create().texOffs(24, 24).addBox(0.0f, -3.0f, -7.5f, 0.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.75f, (float)0.0f, (float)0.0f));
        PartDefinition tail = centipede.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)18.0f));
        PartDefinition tail1 = tail.addOrReplaceChild("tail_1", CubeListBuilder.create().texOffs(24, 0).addBox(-3.0f, -1.5f, 0.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        tail1.addOrReplaceChild("left_feet_4", CubeListBuilder.create().texOffs(12, 18).addBox(-0.25f, 0.0f, -3.0f, 4.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)1.4f, (float)3.0f));
        tail1.addOrReplaceChild("right_feet_4", CubeListBuilder.create().texOffs(12, 18).mirror().addBox(-3.75f, 0.0f, -3.0f, 4.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-3.0f, (float)1.4f, (float)3.0f));
        PartDefinition tail2 = tail1.addOrReplaceChild("tail_2", CubeListBuilder.create().texOffs(24, 9).addBox(-3.0f, -1.5f, 0.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)6.0f));
        tail2.addOrReplaceChild("left_feet_5", CubeListBuilder.create().texOffs(12, 27).addBox(-0.25f, 0.0f, -3.0f, 4.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)1.4f, (float)3.0f));
        tail2.addOrReplaceChild("right_feet_5", CubeListBuilder.create().texOffs(12, 27).mirror().addBox(-3.75f, 0.0f, -3.0f, 4.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-3.0f, (float)1.4f, (float)3.0f));
        PartDefinition tail3 = tail2.addOrReplaceChild("tail_3", CubeListBuilder.create().texOffs(24, 18).addBox(-3.0f, -1.5f, 0.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)6.0f));
        tail3.addOrReplaceChild("left_feet_6", CubeListBuilder.create().texOffs(20, 27).addBox(-0.25f, 0.0f, -3.0f, 4.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)1.4f, (float)3.0f));
        tail3.addOrReplaceChild("right_feet_6", CubeListBuilder.create().texOffs(20, 27).mirror().addBox(-3.75f, 0.0f, -3.0f, 4.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-3.0f, (float)1.4f, (float)3.0f));
        PartDefinition backJaw = tail3.addOrReplaceChild("back_jaw", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)6.0f));
        backJaw.addOrReplaceChild("back_right_jaw", CubeListBuilder.create().texOffs(-10, 36).addBox(-2.0f, 0.0f, -1.0f, 4.0f, 0.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.0f, (float)0.0f));
        backJaw.addOrReplaceChild("back_left_jaw", CubeListBuilder.create().texOffs(-10, 36).mirror().addBox(-2.0f, 0.0f, -1.0f, 4.0f, 0.0f, 10.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)2.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)48, (int)48);
    }

    public void setupAnim(SculkCentipede entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root.getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(netHeadYaw, headPitch);
        this.animateWalk(SculkCentipedeAnimation.CRAWL, limbSwing, limbSwingAmount, 2.0f, 2.5f);
    }

    private void applyHeadRotation(float netHeadYaw, float headPitch) {
        netHeadYaw = Mth.clamp((float)netHeadYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.root.getChild("root").render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public ModelPart root() {
        return this.root;
    }
}

