/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.layout.components;

import com.mojang.blaze3d.systems.RenderSystem;
import de.ambertation.wunderlib.ui.layout.components.ComponentWithBounds;
import de.ambertation.wunderlib.ui.layout.components.Panel;
import de.ambertation.wunderlib.ui.layout.components.render.ComponentRenderer;
import de.ambertation.wunderlib.ui.layout.values.Alignment;
import de.ambertation.wunderlib.ui.layout.values.Rectangle;
import de.ambertation.wunderlib.ui.layout.values.Value;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;

@Environment(value=EnvType.CLIENT)
public abstract class LayoutComponent<R extends ComponentRenderer, L extends LayoutComponent<R, L>>
implements ComponentWithBounds,
class_364 {
    protected final R renderer;
    protected final Value width;
    protected final Value height;
    protected String debugName;
    protected Rectangle relativeBounds;
    protected Rectangle screenBounds;
    protected Alignment vAlign = Alignment.MIN;
    protected Alignment hAlign = Alignment.MIN;
    protected Panel parentPanel;

    public LayoutComponent(Value width, Value height, R renderer) {
        this.width = width.attachComponent(this::getContentWidth);
        this.height = height.attachComponent(this::getContentHeight);
        this.renderer = renderer;
    }

    protected float getZIndex() {
        return this.parentPanel == null ? 0.0f : this.parentPanel.getZIndex();
    }

    protected int updateContainerWidth(int containerWidth) {
        return this.width.setCalculatedSize(containerWidth);
    }

    protected int updateContainerHeight(int containerHeight) {
        return this.height.setCalculatedSize(containerHeight);
    }

    void setRelativeBounds(int left, int top) {
        this.relativeBounds = new Rectangle(left, top, this.width.calculatedSize(), this.height.calculatedSize());
        this.onBoundsChanged();
    }

    public void updateScreenBounds(Panel parentpanel, int worldX, int worldY) {
        this.parentPanel = parentpanel;
        this.screenBounds = this.relativeBounds.movedBy(worldX, worldY);
    }

    protected void onBoundsChanged() {
    }

    @Override
    public Rectangle getRelativeBounds() {
        return this.relativeBounds;
    }

    public Rectangle getScreenBounds() {
        return this.screenBounds;
    }

    public abstract int getContentWidth();

    public abstract int getContentHeight();

    public int fillWidth(int parentSize, int fillSize) {
        return this.width.fill(fillSize);
    }

    public int fillHeight(int parentSize, int fillSize) {
        return this.height.fill(fillSize);
    }

    public int getWidth() {
        return this.width.calculatedSize();
    }

    public int getHeight() {
        return this.height.calculatedSize();
    }

    protected final void setClippingRect(Rectangle clippingRect) {
        if (clippingRect == null) {
            RenderSystem.disableScissor();
            return;
        }
        double uiScale = class_310.method_1551().method_22683().method_4495();
        int windowHeight = class_310.method_1551().method_22683().method_4506();
        RenderSystem.enableScissor((int)((int)((double)clippingRect.left * uiScale)), (int)((int)((double)windowHeight - (double)clippingRect.bottom() * uiScale)), (int)((int)((double)clippingRect.width * uiScale)), (int)((int)((double)clippingRect.height * uiScale)));
    }

    public void render(class_332 guiGraphics, int mouseX, int mouseY, float deltaTicks, Rectangle parentBounds, Rectangle clipRect) {
        Rectangle r = this.relativeBounds.movedBy(parentBounds.left, parentBounds.top);
        Rectangle clip = r.intersect(clipRect);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)this.relativeBounds.left, (float)this.relativeBounds.top, 0.0f);
        this.renderInBounds(guiGraphics, mouseX - this.relativeBounds.left, mouseY - this.relativeBounds.top, deltaTicks, r, clip);
        guiGraphics.method_51448().method_22909();
    }

    protected void renderInBounds(class_332 guiGraphics, int mouseX, int mouseY, float deltaTicks, Rectangle renderBounds, Rectangle clipRect) {
        if (this.renderer != null) {
            this.setClippingRect(clipRect);
            this.renderer.renderInBounds(guiGraphics, mouseX, mouseY, deltaTicks, renderBounds, clipRect);
            this.setClippingRect(null);
        }
    }

    public String toString() {
        if (this.debugName == null) {
            return super.toString() + "(" + String.valueOf(this.relativeBounds) + ", " + this.width.calculatedSize() + "x" + this.height.calculatedSize() + ")";
        }
        return this.debugName + "(" + String.valueOf(this.relativeBounds) + ", " + this.width.calculatedSize() + "x" + this.height.calculatedSize() + ")";
    }

    public L alignTop() {
        this.vAlign = Alignment.MIN;
        return (L)this;
    }

    public L alignBottom() {
        this.vAlign = Alignment.MAX;
        return (L)this;
    }

    public L centerVertical() {
        this.vAlign = Alignment.CENTER;
        return (L)this;
    }

    public L alignLeft() {
        this.hAlign = Alignment.MIN;
        return (L)this;
    }

    public L alignRight() {
        this.hAlign = Alignment.MAX;
        return (L)this;
    }

    public L centerHorizontal() {
        this.hAlign = Alignment.CENTER;
        return (L)this;
    }

    public L setDebugName(String d) {
        this.debugName = d;
        return (L)this;
    }

    public boolean method_25405(double d, double e) {
        return this.relativeBounds.contains(d, e);
    }

    public void reCalculateLayout() {
        this.updateContainerWidth(this.relativeBounds.width);
        this.updateContainerHeight(this.relativeBounds.height);
        this.setRelativeBounds(this.relativeBounds.left, this.relativeBounds.top);
        this.updateScreenBounds(this.parentPanel, this.screenBounds.left, this.screenBounds.top);
    }

    protected void calculateLayoutInParent(Panel parentPanel) {
        this.updateContainerWidth(parentPanel.bounds.width);
        this.updateContainerHeight(parentPanel.bounds.height);
        this.setRelativeBounds(0, 0);
        this.updateScreenBounds(parentPanel, parentPanel.bounds.left, parentPanel.bounds.top);
    }

    public void recalculateLayout() {
        if (this.parentPanel != null) {
            this.parentPanel.calculateLayout();
        }
    }
}

