/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui;

import net.minecraft.class_124;
import net.minecraft.class_5253;

public class ColorHelper {
    public static final int BLACK = class_124.field_1074.method_532() | 0xFF000000;
    public static final int DARK_BLUE = class_124.field_1058.method_532() | 0xFF000000;
    public static final int DARK_GREEN = class_124.field_1077.method_532() | 0xFF000000;
    public static final int DARK_AQUA = class_124.field_1062.method_532() | 0xFF000000;
    public static final int DARK_RED = class_124.field_1079.method_532() | 0xFF000000;
    public static final int DARK_PURPLE = class_124.field_1064.method_532() | 0xFF000000;
    public static final int GOLD = class_124.field_1065.method_532() | 0xFF000000;
    public static final int GRAY = class_124.field_1080.method_532() | 0xFF000000;
    public static final int DARK_GRAY = class_124.field_1063.method_532() | 0xFF000000;
    public static final int BLUE = class_124.field_1078.method_532() | 0xFF000000;
    public static final int GREEN = class_124.field_1060.method_532() | 0xFF000000;
    public static final int AQUA = class_124.field_1075.method_532() | 0xFF000000;
    public static final int RED = class_124.field_1061.method_532() | 0xFF000000;
    public static final int LIGHT_PURPLE = class_124.field_1076.method_532() | 0xFF000000;
    public static final int YELLOW = class_124.field_1054.method_532() | 0xFF000000;
    public static final int WHITE;
    public static final int DEFAULT_TEXT;
    public static final int SCREEN_BACKGROUND = -13355964;
    public static final int CONTAINER_BACKGROUND = 0x77000000;
    public static final int OVERLAY_BACKGROUND = -1761607680;
    public static final int OVERLAY_BORDER = -11184794;

    public static int color(int r, int g, int b) {
        return class_5253.class_5254.method_27764((int)255, (int)r, (int)g, (int)b);
    }

    public static int color(int r, int g, int b, int a) {
        return class_5253.class_5254.method_27764((int)a, (int)r, (int)g, (int)b);
    }

    public static int color(float r, float g, float b, float a) {
        return ColorHelper.color((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f));
    }

    public static int color(String hex) {
        int r = Integer.parseInt(hex.substring(0, 2), 16);
        int g = Integer.parseInt(hex.substring(2, 4), 16);
        int b = Integer.parseInt(hex.substring(4, 6), 16);
        return ColorHelper.color(r, g, b);
    }

    public static int[] toIntTGBA(int color) {
        return new int[]{class_5253.class_5254.method_27765((int)color), class_5253.class_5254.method_27766((int)color), class_5253.class_5254.method_27767((int)color), class_5253.class_5254.method_27762((int)color)};
    }

    public static float[] toFloatArrayRGBA(int color) {
        return new float[]{(float)class_5253.class_5254.method_27765((int)color) / 255.0f, (float)class_5253.class_5254.method_27766((int)color) / 255.0f, (float)class_5253.class_5254.method_27767((int)color) / 255.0f, (float)class_5253.class_5254.method_27762((int)color) / 255.0f};
    }

    public static String toRGBHex(int color) {
        return "#" + Integer.toHexString(class_5253.class_5254.method_27765((int)color)) + Integer.toHexString(class_5253.class_5254.method_27766((int)color)) + Integer.toHexString(class_5253.class_5254.method_27767((int)color));
    }

    public static boolean validHexColor(String hexColor) {
        if (hexColor == null || hexColor.isBlank()) {
            return false;
        }
        try {
            ColorHelper.parseHex(hexColor);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    public static int parseHex(String hexColor) {
        int shift;
        int color;
        int len;
        if (((String)hexColor).startsWith("#")) {
            hexColor = ((String)hexColor).substring(1);
        }
        if (((String)hexColor).startsWith("0x")) {
            hexColor = ((String)hexColor).substring(2);
        }
        if ((len = ((String)hexColor).length()) != 6 && len != 8 && len != 3 && len != 4) {
            return -1;
        }
        if (len == 3) {
            hexColor = "" + ((String)hexColor).charAt(0) + ((String)hexColor).charAt(0) + ((String)hexColor).charAt(1) + ((String)hexColor).charAt(1) + ((String)hexColor).charAt(2) + ((String)hexColor).charAt(2);
            len = 6;
        } else if (len == 4) {
            hexColor = "" + ((String)hexColor).charAt(0) + ((String)hexColor).charAt(0) + ((String)hexColor).charAt(1) + ((String)hexColor).charAt(1) + ((String)hexColor).charAt(2) + ((String)hexColor).charAt(2) + ((String)hexColor).charAt(3) + ((String)hexColor).charAt(3);
            len = 8;
        }
        if (len == 6) {
            color = -16777216;
            shift = 16;
        } else {
            color = 0;
            shift = 24;
        }
        try {
            String[] splited;
            for (String digit : splited = ((String)hexColor).split("(?<=\\G.{2})")) {
                color |= Integer.valueOf(digit, 16) << shift;
                shift -= 8;
            }
        }
        catch (NumberFormatException ex) {
            return -1;
        }
        return color;
    }

    public static int blendColors(float t, int c1, int c2) {
        int r = (int)(t * (float)class_5253.class_5254.method_27765((int)c2) + (1.0f - t) * (float)class_5253.class_5254.method_27765((int)c1));
        int g = (int)(t * (float)class_5253.class_5254.method_27766((int)c2) + (1.0f - t) * (float)class_5253.class_5254.method_27766((int)c1));
        int b = (int)(t * (float)class_5253.class_5254.method_27767((int)c2) + (1.0f - t) * (float)class_5253.class_5254.method_27767((int)c1));
        int a = (int)(t * (float)class_5253.class_5254.method_27762((int)c2) + (1.0f - t) * (float)class_5253.class_5254.method_27762((int)c1));
        return class_5253.class_5254.method_27764((int)a, (int)r, (int)g, (int)b);
    }

    static {
        DEFAULT_TEXT = WHITE = class_124.field_1068.method_532() | 0xFF000000;
    }
}

