/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.math.sdf.shapes;

import de.ambertation.wunderlib.math.Bounds;
import de.ambertation.wunderlib.math.Float3;
import de.ambertation.wunderlib.math.Matrix4;
import de.ambertation.wunderlib.math.Quaternion;
import de.ambertation.wunderlib.math.Transform;
import de.ambertation.wunderlib.math.sdf.SDF;
import de.ambertation.wunderlib.math.sdf.interfaces.MaterialProvider;
import de.ambertation.wunderlib.math.sdf.interfaces.Transformable;
import org.jetbrains.annotations.NotNull;

public abstract class BaseShape
extends SDF
implements MaterialProvider,
Transformable {
    protected int materialIndex;
    @NotNull
    protected Transform transform;

    protected BaseShape(Transform t, int materialIndex) {
        super(0);
        this.transform = t;
        this.materialIndex = materialIndex;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.graphIndex + "]";
    }

    public Float3 getCenter() {
        return this.transform.center.blockAligned();
    }

    @Override
    public Bounds getBoundingBox() {
        return this.transform.getBoundingBoxWorldSpace(this.getParentTransformMatrix());
    }

    @Override
    public Bounds getLocalBoundingBox(Matrix4 m) {
        return this.transform.getBoundingBoxWorldSpace(this.getLocalTransform().asInvertedMatrix().mul(m));
    }

    @Override
    public int getMaterialIndex() {
        return this.materialIndex;
    }

    @Override
    public void setMaterialIndex(int newMaterialIndex) {
        this.materialIndex = newMaterialIndex;
    }

    public void rotate(double angle) {
        this.transform = this.transform.rotateBy(Quaternion.ofAxisAngle(Float3.Y_AXIS, angle));
    }

    @Override
    public Transform getLocalTransform() {
        return this.transform;
    }

    @Override
    public Float3[] getCornersInWorldSpace(boolean blockAligned, Transform transform) {
        return transform.getCornersInWorldSpace(blockAligned, this.getParentTransformMatrix());
    }

    @Override
    public Float3[] getCornersAndCenterInWorldSpace(boolean blockAligned, Transform transform) {
        return transform.getCornersAndCenterInWorldSpace(blockAligned, this.getParentTransformMatrix());
    }

    @Override
    public Float3 getCornerInWorldSpace(Bounds.Interpolate corner, boolean blockAligned, Transform transform) {
        return transform.getCornerInWorldSpace(corner, blockAligned, this.getParentTransformMatrix());
    }

    @Override
    public void setLocalTransform(Transform t) {
        this.transform = t;
    }

    @Override
    public boolean isOperation() {
        return false;
    }
}

