/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.configs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.ambertation.wunderlib.WunderLib;
import de.ambertation.wunderlib.configs.AbstractConfig;
import de.ambertation.wunderlib.utils.Version;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.Nullable;

public class ConfigFile
extends AbstractConfig<ConfigFile> {
    private final File path;

    public ConfigFile(Version.ModVersionProvider versionProvider, String category) {
        this(versionProvider, versionProvider.getNamespace(), category);
    }

    public ConfigFile(Version.ModVersionProvider versionProvider, String basePath, String category) {
        super(versionProvider, basePath, category);
        Path dir = FabricLoader.getInstance().getConfigDir().resolve(basePath);
        this.path = dir.resolve(category + ".json").toFile();
        if (!dir.toFile().exists()) {
            dir.toFile().mkdirs();
        }
        this.loadFromDisc();
    }

    @Override
    protected boolean isReadOnly() {
        return false;
    }

    @Override
    @Nullable
    protected JsonObject loadRootElement() {
        if (this.path.exists()) {
            JsonObject jsonObject;
            FileReader reader = new FileReader(this.path);
            try {
                jsonObject = ((JsonElement)AbstractConfig.JSON_BUILDER.fromJson((Reader)reader, JsonElement.class)).getAsJsonObject();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    WunderLib.LOGGER.error("Unable to open Config File at '{}'.", this.path.toString(), ex);
                }
            }
            ((Reader)reader).close();
            return jsonObject;
        }
        return null;
    }

    @Override
    protected boolean saveRootElement(String root) {
        try (FileWriter jsonWriter = new FileWriter(this.path);){
            jsonWriter.write(root);
            jsonWriter.flush();
        }
        catch (IOException ex) {
            WunderLib.LOGGER.error("Unable to store Config File at '{}'.", this.path.toString(), ex);
            return false;
        }
        return true;
    }
}

