/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.jei.common;

import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.grid.CraftingGridContainerMenu;
import com.refinedmods.refinedstorage.common.grid.screen.AbstractGridScreen;
import com.refinedmods.refinedstorage.common.support.AbstractBaseScreen;
import com.refinedmods.refinedstorage.jei.common.CraftingGridRecipeTransferHandler;
import com.refinedmods.refinedstorage.jei.common.ExclusionZonesGuiContainerHandler;
import com.refinedmods.refinedstorage.jei.common.FilterGhostIngredientHandler;
import com.refinedmods.refinedstorage.jei.common.GridGuiContainerHandler;
import com.refinedmods.refinedstorage.jei.common.PatternGridCraftingRecipeTransferHandler;
import com.refinedmods.refinedstorage.jei.common.PatternGridProcessingRecipeTransferHandler;
import com.refinedmods.refinedstorage.jei.common.PatternGridSmithingTableRecipeTransferHandler;
import com.refinedmods.refinedstorage.jei.common.PatternGridStonecutterRecipeTransferHandler;
import com.refinedmods.refinedstorage.jei.common.QuartzArsenalIntegration;
import com.refinedmods.refinedstorage.jei.common.ResourceGhostIngredientHandler;
import com.refinedmods.refinedstorage.jei.common.ResourceGuiContainerHandler;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IUniversalRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IIngredientAliasRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

@JeiPlugin
public class RefinedStorageModPlugin
implements IModPlugin {
    private static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"refinedstorage_jei_integration", (String)"plugin");
    @Nullable
    private static IJeiRuntime runtime;

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerIngredientAliases(IIngredientAliasRegistration registration) {
        registration.addAliases((IIngredientType)VanillaTypes.ITEM_STACK, Items.INSTANCE.getDiskInterfaces().stream().map(Supplier::get).map(Item::getDefaultInstance).toList(), "alias.%s.refinedstorage1_disk_manipulator".formatted("refinedstorage_jei_integration"));
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(new CraftingGridRecipeTransferHandler<CraftingGridContainerMenu>(CraftingGridContainerMenu.class), RecipeTypes.CRAFTING);
        if (QuartzArsenalIntegration.isLoaded()) {
            QuartzArsenalIntegration.load(registration);
        }
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new PatternGridCraftingRecipeTransferHandler(), RecipeTypes.CRAFTING);
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new PatternGridStonecutterRecipeTransferHandler(), RecipeTypes.STONECUTTING);
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new PatternGridSmithingTableRecipeTransferHandler(), RecipeTypes.SMITHING);
        registration.addUniversalRecipeTransferHandler((IUniversalRecipeTransferHandler)new PatternGridProcessingRecipeTransferHandler());
    }

    public void onRuntimeAvailable(IJeiRuntime newRuntime) {
        runtime = newRuntime;
    }

    public void onRuntimeUnavailable() {
        runtime = null;
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGenericGuiContainerHandler(AbstractBaseScreen.class, (IGuiContainerHandler)new ResourceGuiContainerHandler(registration.getJeiHelpers().getIngredientManager()));
        registration.addGenericGuiContainerHandler(AbstractGridScreen.class, (IGuiContainerHandler)new GridGuiContainerHandler(registration.getJeiHelpers().getIngredientManager()));
        registration.addGenericGuiContainerHandler(AbstractBaseScreen.class, (IGuiContainerHandler)new ExclusionZonesGuiContainerHandler());
        registration.addGhostIngredientHandler(AbstractBaseScreen.class, (IGhostIngredientHandler)new ResourceGhostIngredientHandler());
        registration.addGhostIngredientHandler(AbstractBaseScreen.class, (IGhostIngredientHandler)new FilterGhostIngredientHandler());
    }

    @Nullable
    public static IJeiRuntime getRuntime() {
        return runtime;
    }
}

