/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.network;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.CoreSide;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class PacketContext {
    private final IPayloadContext context;

    public PacketContext(IPayloadContext context) {
        this.context = context;
    }

    public CoreSide getHandlingSide() {
        return this.context.flow().isClientbound() ? CoreSide.CLIENT : CoreSide.SERVER;
    }

    public CoreSide getOriginatingSide() {
        return this.context.flow().isServerbound() ? CoreSide.CLIENT : CoreSide.SERVER;
    }

    public Player getSendingPlayer() {
        return this.context.player();
    }

    public Level getWorld() {
        return this.getHandlingSide() == CoreSide.CLIENT ? ClientUtils.getWorld() : this.getSendingPlayer().level();
    }

    public void queueTask(Runnable task) {
        this.context.enqueueWork(task);
    }

    @Deprecated
    public IPayloadContext getUnderlyingContext() {
        return this.context;
    }
}

