/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.biome.impl.modification.predicates;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.KeyDispatchDataCodec;
import org.betterx.wover.biome.api.modification.predicates.BiomePredicate;
import org.betterx.wover.biome.api.modification.predicates.BiomePredicateRegistry;
import org.betterx.wover.biome.impl.modification.predicates.Always;
import org.betterx.wover.biome.impl.modification.predicates.And;
import org.betterx.wover.biome.impl.modification.predicates.ConfigIs;
import org.betterx.wover.biome.impl.modification.predicates.HasConfiguredFeature;
import org.betterx.wover.biome.impl.modification.predicates.HasPlacedFeature;
import org.betterx.wover.biome.impl.modification.predicates.HasStructure;
import org.betterx.wover.biome.impl.modification.predicates.HasTag;
import org.betterx.wover.biome.impl.modification.predicates.InDimension;
import org.betterx.wover.biome.impl.modification.predicates.IsBiome;
import org.betterx.wover.biome.impl.modification.predicates.IsNamespace;
import org.betterx.wover.biome.impl.modification.predicates.LocationPathContains;
import org.betterx.wover.biome.impl.modification.predicates.Not;
import org.betterx.wover.biome.impl.modification.predicates.Or;
import org.betterx.wover.biome.impl.modification.predicates.Spawns;
import org.betterx.wover.core.api.registry.BuiltInRegistryManager;
import org.betterx.wover.entrypoint.LibWoverBiome;
import org.jetbrains.annotations.ApiStatus;

public class BiomePredicateRegistryImpl {
    public static final Registry<MapCodec<? extends BiomePredicate>> BIOME_PREDICATES = BuiltInRegistryManager.createRegistry(BiomePredicateRegistry.BIOME_PREDICATE_REGISTRY, BiomePredicateRegistryImpl::onBootstrap);

    public static MapCodec<? extends BiomePredicate> register(Registry<MapCodec<? extends BiomePredicate>> registry, ResourceLocation location, KeyDispatchDataCodec<? extends BiomePredicate> keyDispatchDataCodec) {
        return (MapCodec)Registry.register(registry, (ResourceLocation)location, (Object)keyDispatchDataCodec.codec());
    }

    @ApiStatus.Internal
    public static void initialize() {
        BiomePredicateRegistryImpl.onBootstrap(BIOME_PREDICATES);
    }

    private static MapCodec<? extends BiomePredicate> onBootstrap(Registry<MapCodec<? extends BiomePredicate>> registry) {
        ResourceLocation all = LibWoverBiome.C.id("all");
        if (registry.containsKey(all)) {
            return (MapCodec)registry.get(all);
        }
        BiomePredicateRegistryImpl.register(registry, LibWoverBiome.C.id("not"), Not.CODEC);
        BiomePredicateRegistryImpl.register(registry, LibWoverBiome.C.id("and"), And.CODEC);
        BiomePredicateRegistryImpl.register(registry, LibWoverBiome.C.id("or"), Or.CODEC);
        BiomePredicateRegistryImpl.register(registry, LibWoverBiome.C.id("is_biome"), IsBiome.CODEC);
        BiomePredicateRegistryImpl.register(registry, LibWoverBiome.C.id("has_tag"), HasTag.CODEC);
        BiomePredicateRegistryImpl.register(registry, LibWoverBiome.C.id("in_dimension"), InDimension.CODEC);
        BiomePredicateRegistryImpl.register(registry, LibWoverBiome.C.id("is_namespace"), IsNamespace.CODEC);
        BiomePredicateRegistryImpl.register(registry, LibWoverBiome.C.id("location_path_contains"), LocationPathContains.CODEC);
        BiomePredicateRegistryImpl.register(registry, LibWoverBiome.C.id("spawns"), Spawns.CODEC);
        BiomePredicateRegistryImpl.register(registry, LibWoverBiome.C.id("has_structure"), HasStructure.CODEC);
        BiomePredicateRegistryImpl.register(registry, LibWoverBiome.C.id("has_placed_feature"), HasPlacedFeature.CODEC);
        BiomePredicateRegistryImpl.register(registry, LibWoverBiome.C.id("has_configured_feature"), HasConfiguredFeature.CODEC);
        BiomePredicateRegistryImpl.register(registry, LibWoverBiome.C.id("config_is"), ConfigIs.CODEC);
        return BiomePredicateRegistryImpl.register(registry, all, Always.CODEC);
    }
}

